/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.classfile;

import java.io.DataOutput;
import java.io.IOException;
import org.teatrove.trove.classfile.ConstantClassInfo;
import org.teatrove.trove.classfile.ConstantInfo;
import org.teatrove.trove.classfile.ConstantNameAndTypeInfo;
import org.teatrove.trove.classfile.ConstantPool;

public class ConstantFieldInfo
extends ConstantInfo {
    private ConstantClassInfo mParentClass;
    private ConstantNameAndTypeInfo mNameAndType;

    static ConstantFieldInfo make(ConstantPool cp, ConstantClassInfo parentClass, ConstantNameAndTypeInfo nameAndType) {
        ConstantFieldInfo ci = new ConstantFieldInfo(parentClass, nameAndType);
        return (ConstantFieldInfo)cp.addConstant(ci);
    }

    ConstantFieldInfo(ConstantClassInfo parentClass, ConstantNameAndTypeInfo nameAndType) {
        super(9);
        this.mParentClass = parentClass;
        this.mNameAndType = nameAndType;
    }

    public ConstantClassInfo getParentClass() {
        return this.mParentClass;
    }

    public ConstantNameAndTypeInfo getNameAndType() {
        return this.mNameAndType;
    }

    public int hashCode() {
        return this.mNameAndType.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ConstantFieldInfo) {
            ConstantFieldInfo other = (ConstantFieldInfo)obj;
            return this.mParentClass.equals(other.mParentClass) && this.mNameAndType.equals(other.mNameAndType);
        }
        return false;
    }

    @Override
    public void writeTo(DataOutput dout) throws IOException {
        super.writeTo(dout);
        dout.writeShort(this.mParentClass.getIndex());
        dout.writeShort(this.mNameAndType.getIndex());
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("CONSTANT_Fieldref_info: ");
        buf.append(this.getParentClass().getType().getFullName());
        ConstantNameAndTypeInfo cnati = this.getNameAndType();
        buf.append(' ');
        buf.append(cnati.getName());
        buf.append(' ');
        buf.append(cnati.getType());
        return buf.toString();
    }
}

