/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.classfile;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import org.teatrove.trove.classfile.ClassFile;
import org.teatrove.trove.classfile.CodeAssembler;
import org.teatrove.trove.classfile.CodeAttr;
import org.teatrove.trove.classfile.CodeBuffer;
import org.teatrove.trove.classfile.ConstantClassInfo;
import org.teatrove.trove.classfile.ConstantDoubleInfo;
import org.teatrove.trove.classfile.ConstantFieldInfo;
import org.teatrove.trove.classfile.ConstantFloatInfo;
import org.teatrove.trove.classfile.ConstantInfo;
import org.teatrove.trove.classfile.ConstantIntegerInfo;
import org.teatrove.trove.classfile.ConstantInterfaceMethodInfo;
import org.teatrove.trove.classfile.ConstantLongInfo;
import org.teatrove.trove.classfile.ConstantMethodInfo;
import org.teatrove.trove.classfile.ConstantPool;
import org.teatrove.trove.classfile.ConstantStringInfo;
import org.teatrove.trove.classfile.ExceptionHandler;
import org.teatrove.trove.classfile.InstructionList;
import org.teatrove.trove.classfile.Label;
import org.teatrove.trove.classfile.LocalVariable;
import org.teatrove.trove.classfile.Location;
import org.teatrove.trove.classfile.MethodInfo;
import org.teatrove.trove.classfile.Opcode;
import org.teatrove.trove.classfile.TypeDesc;

public class CodeBuilder
implements CodeBuffer,
CodeAssembler {
    private String mName;
    private CodeAttr mCodeAttr;
    private ClassFile mClassFile;
    private ConstantPool mCp;
    private InstructionList mInstructions = new InstructionList();
    private LocalVariable mThisReference;
    private LocalVariable[] mParameters;
    private boolean mSaveLineNumberInfo;
    private boolean mSaveLocalVariableInfo;

    public CodeBuilder(MethodInfo info) {
        this(info, true, false);
    }

    public CodeBuilder(MethodInfo info, boolean saveLineNumberInfo, boolean saveLocalVariableInfo) {
        LocalVariable localVar;
        this.mName = info.getName();
        this.mCodeAttr = info.getCodeAttr();
        this.mClassFile = info.getClassFile();
        this.mCp = this.mClassFile.getConstantPool();
        this.mCodeAttr.setCodeBuffer(this);
        this.mSaveLineNumberInfo = saveLineNumberInfo;
        this.mSaveLocalVariableInfo = saveLocalVariableInfo;
        int varNum = 0;
        if (!info.getModifiers().isStatic()) {
            this.mThisReference = localVar = this.mInstructions.createLocalParameter("this", this.mClassFile.getType(), varNum++);
            if (saveLocalVariableInfo) {
                this.mCodeAttr.localVariableUse(localVar);
            }
        }
        TypeDesc[] paramTypes = info.getMethodDescriptor().getParameterTypes();
        String[] paramNames = info.getMethodDescriptor().getParameterNames();
        int paramSize = paramTypes.length;
        this.mParameters = new LocalVariable[paramSize];
        for (int i = 0; i < paramTypes.length; ++i) {
            varNum += (localVar = this.mInstructions.createLocalParameter(paramNames[i], paramTypes[i], varNum)).isDoubleWord() ? 2 : 1;
            this.mParameters[i] = localVar;
            if (!saveLocalVariableInfo) continue;
            this.mCodeAttr.localVariableUse(localVar);
        }
    }

    @Override
    public int getMaxStackDepth() {
        return this.mInstructions.getMaxStackDepth();
    }

    @Override
    public int getMaxLocals() {
        return this.mInstructions.getMaxLocals();
    }

    @Override
    public byte[] getByteCodes() {
        try {
            return this.mInstructions.getByteCodes();
        }
        catch (Exception exception) {
            StringBuilder error = new StringBuilder();
            error.append("error generating code: ").append(this.mClassFile.getClassName()).append('.').append(this.mName).append('(');
            for (int i = 0; i < this.mParameters.length; ++i) {
                if (i > 0) {
                    error.append(", ");
                }
                error.append(this.mParameters[i].getType()).append(' ').append(this.mParameters[i].getName());
            }
            error.append(')');
            throw new RuntimeException(error.toString(), exception);
        }
    }

    @Override
    public ExceptionHandler[] getExceptionHandlers() {
        return this.mInstructions.getExceptionHandlers();
    }

    private void addCode(int stackAdjust, byte opcode) {
        InstructionList instructionList = this.mInstructions;
        instructionList.getClass();
        new InstructionList.CodeInstruction(instructionList, stackAdjust, new byte[]{opcode});
    }

    private void addCode(int stackAdjust, byte opcode, byte operand) {
        InstructionList instructionList = this.mInstructions;
        instructionList.getClass();
        new InstructionList.CodeInstruction(instructionList, stackAdjust, new byte[]{opcode, operand});
    }

    private void addCode(int stackAdjust, byte opcode, short operand) {
        InstructionList instructionList = this.mInstructions;
        instructionList.getClass();
        new InstructionList.CodeInstruction(instructionList, stackAdjust, new byte[]{opcode, (byte)(operand >> 8), (byte)operand});
    }

    private void addCode(int stackAdjust, byte opcode, ConstantInfo info) {
        InstructionList instructionList = this.mInstructions;
        instructionList.getClass();
        new InstructionList.ConstantOperandInstruction(instructionList, stackAdjust, new byte[]{opcode, 0, 0}, info);
    }

    @Override
    public LocalVariable[] getParameters() {
        return (LocalVariable[])this.mParameters.clone();
    }

    @Override
    public LocalVariable createLocalVariable(String name, TypeDesc type) {
        LocalVariable localVar = this.mInstructions.createLocalVariable(name, type);
        if (this.mSaveLocalVariableInfo) {
            this.mCodeAttr.localVariableUse(localVar);
        }
        return localVar;
    }

    @Override
    public Label createLabel() {
        return new InstructionList.LabelInstruction(this.mInstructions);
    }

    @Override
    public void exceptionHandler(Location startLocation, Location endLocation, String catchClassName) {
        Label catchLocation = this.createLabel().setLocation();
        ConstantClassInfo catchClass = catchClassName == null ? null : ConstantClassInfo.make(this.mCp, catchClassName);
        ExceptionHandler handler = new ExceptionHandler(startLocation, endLocation, catchLocation, catchClass);
        this.mInstructions.addExceptionHandler(handler);
    }

    @Override
    public void mapLineNumber(int lineNumber) {
        if (this.mSaveLineNumberInfo) {
            this.mCodeAttr.mapLineNumber(this.createLabel().setLocation(), lineNumber);
        }
    }

    public void loadNull() {
        this.addCode(1, (byte)1);
    }

    @Override
    public void loadConstant(String value) {
        if (value == null) {
            this.loadNull();
            return;
        }
        int strlen = value.length();
        if (strlen <= 21845) {
            ConstantStringInfo info = ConstantStringInfo.make(this.mCp, value);
            InstructionList instructionList = this.mInstructions;
            instructionList.getClass();
            new InstructionList.LoadConstantInstruction(instructionList, 1, info);
            return;
        }
        int utflen = 0;
        for (int i = 0; i < strlen; ++i) {
            char c = value.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        if (utflen <= 65535) {
            ConstantStringInfo info = ConstantStringInfo.make(this.mCp, value);
            InstructionList instructionList = this.mInstructions;
            instructionList.getClass();
            new InstructionList.LoadConstantInstruction(instructionList, 1, info);
            return;
        }
        TypeDesc stringBufferDesc = TypeDesc.forClass(StringBuffer.class);
        TypeDesc intDesc = TypeDesc.INT;
        TypeDesc stringDesc = TypeDesc.STRING;
        TypeDesc[] stringParam = new TypeDesc[]{stringDesc};
        this.newObject(stringBufferDesc);
        this.dup();
        this.loadConstant(strlen);
        this.invokeConstructor("java.lang.StringBuffer", intDesc);
        int endIndex = 0;
        while (endIndex < strlen) {
            char c;
            int size;
            int beginIndex = endIndex;
            utflen = 0;
            while (endIndex < strlen && utflen + (size = (c = value.charAt(endIndex)) >= '\u0001' && c <= '\u007f' ? 1 : (c > '\u07ff' ? 3 : 2)) <= 65535) {
                utflen += size;
                ++endIndex;
            }
            String substr = value.substring(beginIndex, endIndex);
            ConstantStringInfo info = ConstantStringInfo.make(this.mCp, substr);
            InstructionList instructionList = this.mInstructions;
            instructionList.getClass();
            new InstructionList.LoadConstantInstruction(instructionList, 1, info);
            this.invokeVirtual("java.lang.StringBuffer", "append", stringBufferDesc, stringParam);
        }
        this.invokeVirtual("java.lang.StringBuffer", "toString", stringDesc, new TypeDesc[0]);
    }

    @Override
    public void loadConstant(boolean value) {
        this.loadConstant(value ? 1 : 0);
    }

    @Override
    public void loadConstant(int value) {
        if (-1 <= value && value <= 5) {
            byte op;
            switch (value) {
                case -1: {
                    op = 2;
                    break;
                }
                case 0: {
                    op = 3;
                    break;
                }
                case 1: {
                    op = 4;
                    break;
                }
                case 2: {
                    op = 5;
                    break;
                }
                case 3: {
                    op = 6;
                    break;
                }
                case 4: {
                    op = 7;
                    break;
                }
                case 5: {
                    op = 8;
                    break;
                }
                default: {
                    op = 0;
                }
            }
            this.addCode(1, op);
        } else if (-128 <= value && value <= 127) {
            this.addCode(1, (byte)16, (byte)value);
        } else if (Short.MIN_VALUE <= value && value <= Short.MAX_VALUE) {
            this.addCode(1, (byte)17, (short)value);
        } else {
            ConstantIntegerInfo info = ConstantIntegerInfo.make(this.mCp, value);
            InstructionList instructionList = this.mInstructions;
            instructionList.getClass();
            new InstructionList.LoadConstantInstruction(instructionList, 1, info);
        }
    }

    @Override
    public void loadConstant(long value) {
        if (value == 0L) {
            this.addCode(2, (byte)9);
        } else if (value == 1L) {
            this.addCode(2, (byte)10);
        } else {
            ConstantLongInfo info = ConstantLongInfo.make(this.mCp, value);
            InstructionList instructionList = this.mInstructions;
            instructionList.getClass();
            new InstructionList.LoadConstantInstruction(instructionList, 2, info, true);
        }
    }

    @Override
    public void loadConstant(float value) {
        if (value == 0.0f) {
            this.addCode(1, (byte)11);
        } else if (value == 1.0f) {
            this.addCode(1, (byte)12);
        } else if (value == 2.0f) {
            this.addCode(1, (byte)13);
        } else {
            ConstantFloatInfo info = ConstantFloatInfo.make(this.mCp, value);
            InstructionList instructionList = this.mInstructions;
            instructionList.getClass();
            new InstructionList.LoadConstantInstruction(instructionList, 1, info);
        }
    }

    @Override
    public void loadConstant(double value) {
        if (value == 0.0) {
            this.addCode(2, (byte)14);
        } else if (value == 1.0) {
            this.addCode(2, (byte)15);
        } else {
            ConstantDoubleInfo info = ConstantDoubleInfo.make(this.mCp, value);
            InstructionList instructionList = this.mInstructions;
            instructionList.getClass();
            new InstructionList.LoadConstantInstruction(instructionList, 2, info, true);
        }
    }

    public void loadThisClass() {
        this.loadClass(this.mClassFile.getType());
    }

    public void loadClass(Class clazz) {
        this.loadClass(TypeDesc.forClass(clazz));
    }

    public void loadClass(TypeDesc clazz) {
        ConstantClassInfo info = this.mCp.addConstantClass(clazz.getFullName());
        InstructionList instructionList = this.mInstructions;
        instructionList.getClass();
        new InstructionList.LoadConstantInstruction(instructionList, 1, info);
    }

    @Override
    public void loadLocal(LocalVariable local) {
        if (local == null) {
            throw new NullPointerException("No local variable specified");
        }
        int stackAdjust = local.getType().isDoubleWord() ? 2 : 1;
        InstructionList instructionList = this.mInstructions;
        instructionList.getClass();
        new InstructionList.LoadLocalInstruction(instructionList, stackAdjust, local);
    }

    @Override
    public void loadThis() {
        if (this.mThisReference == null) {
            throw new RuntimeException("Attempt to load \"this\" reference in a static method: " + this.mClassFile.getClassName() + "." + this.mName);
        }
        this.loadLocal(this.mThisReference);
    }

    @Override
    public void storeLocal(LocalVariable local) {
        if (local == null) {
            throw new NullPointerException("No local variable specified");
        }
        int stackAdjust = local.getType().isDoubleWord() ? -2 : -1;
        InstructionList instructionList = this.mInstructions;
        instructionList.getClass();
        new InstructionList.StoreLocalInstruction(instructionList, stackAdjust, local);
    }

    @Override
    public void loadFromArray(TypeDesc type) {
        byte op;
        int stackAdjust = -1;
        switch (type.getTypeCode()) {
            case 10: {
                op = 46;
                break;
            }
            case 4: 
            case 8: {
                op = 51;
                break;
            }
            case 9: {
                op = 53;
                break;
            }
            case 5: {
                op = 52;
                break;
            }
            case 6: {
                op = 48;
                break;
            }
            case 11: {
                stackAdjust = 0;
                op = 47;
                break;
            }
            case 7: {
                stackAdjust = 0;
                op = 49;
                break;
            }
            default: {
                op = 50;
            }
        }
        this.addCode(stackAdjust, op);
    }

    @Override
    public void storeToArray(TypeDesc type) {
        byte op;
        int stackAdjust = -3;
        switch (type.getTypeCode()) {
            case 10: {
                op = 79;
                break;
            }
            case 4: 
            case 8: {
                op = 84;
                break;
            }
            case 9: {
                op = 86;
                break;
            }
            case 5: {
                op = 85;
                break;
            }
            case 6: {
                op = 81;
                break;
            }
            case 11: {
                stackAdjust = -4;
                op = 80;
                break;
            }
            case 7: {
                stackAdjust = -4;
                op = 82;
                break;
            }
            default: {
                op = 83;
            }
        }
        this.addCode(stackAdjust, op);
    }

    @Override
    public void loadField(String fieldName, TypeDesc type) {
        this.getfield(0, (byte)-76, this.constantField(fieldName, type), type);
    }

    @Override
    public void loadField(String className, String fieldName, TypeDesc type) {
        this.getfield(0, (byte)-76, this.mCp.addConstantField(className, fieldName, type), type);
    }

    @Override
    public void loadStaticField(String fieldName, TypeDesc type) {
        this.getfield(1, (byte)-78, this.constantField(fieldName, type), type);
    }

    @Override
    public void loadStaticField(String className, String fieldName, TypeDesc type) {
        this.getfield(1, (byte)-78, this.mCp.addConstantField(className, fieldName, type), type);
    }

    private void getfield(int stackAdjust, byte opcode, ConstantInfo info, TypeDesc type) {
        if (type.isDoubleWord()) {
            ++stackAdjust;
        }
        this.addCode(stackAdjust, opcode, info);
    }

    private ConstantFieldInfo constantField(String fieldName, TypeDesc type) {
        return this.mCp.addConstantField(this.mClassFile.getClassName(), fieldName, type);
    }

    @Override
    public void storeField(String fieldName, TypeDesc type) {
        this.putfield(-1, (byte)-75, this.constantField(fieldName, type), type);
    }

    @Override
    public void storeField(String className, String fieldName, TypeDesc type) {
        this.putfield(-1, (byte)-75, this.mCp.addConstantField(className, fieldName, type), type);
    }

    @Override
    public void storeStaticField(String fieldName, TypeDesc type) {
        this.putfield(0, (byte)-77, this.constantField(fieldName, type), type);
    }

    @Override
    public void storeStaticField(String className, String fieldName, TypeDesc type) {
        this.putfield(0, (byte)-77, this.mCp.addConstantField(className, fieldName, type), type);
    }

    private void putfield(int stackAdjust, byte opcode, ConstantInfo info, TypeDesc type) {
        stackAdjust = type.isDoubleWord() ? (stackAdjust -= 2) : --stackAdjust;
        this.addCode(stackAdjust, opcode, info);
    }

    @Override
    public void returnVoid() {
        this.addCode(0, (byte)-79);
    }

    @Override
    public void returnValue(TypeDesc type) {
        byte op;
        int stackAdjust = -1;
        switch (type.getTypeCode()) {
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                op = -84;
                break;
            }
            case 6: {
                op = -82;
                break;
            }
            case 11: {
                stackAdjust = -2;
                op = -83;
                break;
            }
            case 7: {
                stackAdjust = -2;
                op = -81;
                break;
            }
            case 1: {
                stackAdjust = 0;
                op = -79;
                break;
            }
            default: {
                op = -80;
            }
        }
        this.addCode(stackAdjust, op);
    }

    @Override
    public void convert(TypeDesc fromType, TypeDesc toType) {
        byte op;
        TypeDesc toPrimitiveType;
        if (toType == TypeDesc.OBJECT) {
            if (fromType.isPrimitive()) {
                toType = fromType.toObjectType();
            } else {
                return;
            }
        }
        if (fromType == toType) {
            return;
        }
        TypeDesc fromPrimitiveType = fromType.toPrimitiveType();
        if (fromPrimitiveType == null) {
            throw this.invalidConversion(fromType, toType);
        }
        int fromTypeCode = fromPrimitiveType.getTypeCode();
        if (!fromType.isPrimitive()) {
            this.unbox(fromType, fromPrimitiveType);
        }
        if ((toPrimitiveType = toType.toPrimitiveType()) == null) {
            throw this.invalidConversion(fromType, toType);
        }
        int toTypeCode = toPrimitiveType.getTypeCode();
        int stackAdjust = 0;
        block0 : switch (fromTypeCode) {
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                switch (toTypeCode) {
                    case 8: {
                        op = fromTypeCode == 8 ? (byte)0 : -111;
                        break block0;
                    }
                    case 9: {
                        op = fromTypeCode == 9 ? (byte)0 : -109;
                        break block0;
                    }
                    case 5: {
                        op = fromTypeCode == 5 ? (byte)0 : -110;
                        break block0;
                    }
                    case 6: {
                        op = -122;
                        break block0;
                    }
                    case 11: {
                        stackAdjust = 1;
                        op = -123;
                        break block0;
                    }
                    case 7: {
                        stackAdjust = 1;
                        op = -121;
                        break block0;
                    }
                    case 10: {
                        op = 0;
                        break block0;
                    }
                    case 4: {
                        this.toBoolean(!toType.isPrimitive());
                        return;
                    }
                }
                throw this.invalidConversion(fromType, toType);
            }
            case 11: {
                switch (toTypeCode) {
                    case 10: {
                        stackAdjust = -1;
                        op = -120;
                        break block0;
                    }
                    case 6: {
                        stackAdjust = -1;
                        op = -119;
                        break block0;
                    }
                    case 7: {
                        op = -118;
                        break block0;
                    }
                    case 5: 
                    case 8: 
                    case 9: {
                        this.addCode(-1, (byte)-120);
                        this.convert(TypeDesc.INT, toPrimitiveType);
                    }
                    case 11: {
                        op = 0;
                        break block0;
                    }
                    case 4: {
                        this.loadConstant(0L);
                        this.math((byte)-108);
                        this.toBoolean(!toType.isPrimitive());
                        return;
                    }
                }
                throw this.invalidConversion(fromType, toType);
            }
            case 6: {
                switch (toTypeCode) {
                    case 10: {
                        op = -117;
                        break block0;
                    }
                    case 11: {
                        stackAdjust = 1;
                        op = -116;
                        break block0;
                    }
                    case 7: {
                        stackAdjust = 1;
                        op = -115;
                        break block0;
                    }
                    case 5: 
                    case 8: 
                    case 9: {
                        this.addCode(0, (byte)-117);
                        this.convert(TypeDesc.INT, toPrimitiveType);
                    }
                    case 6: {
                        op = 0;
                        break block0;
                    }
                    case 4: {
                        this.loadConstant(0.0f);
                        this.math((byte)-106);
                        this.toBoolean(!toType.isPrimitive());
                        return;
                    }
                }
                throw this.invalidConversion(fromType, toType);
            }
            case 7: {
                switch (toTypeCode) {
                    case 10: {
                        stackAdjust = -1;
                        op = -114;
                        break block0;
                    }
                    case 6: {
                        stackAdjust = -1;
                        op = -112;
                        break block0;
                    }
                    case 11: {
                        op = -113;
                        break block0;
                    }
                    case 5: 
                    case 8: 
                    case 9: {
                        this.addCode(-1, (byte)-114);
                        this.convert(TypeDesc.INT, toPrimitiveType);
                    }
                    case 7: {
                        op = 0;
                        break block0;
                    }
                    case 4: {
                        this.loadConstant(0.0);
                        this.math((byte)-104);
                        this.toBoolean(!toType.isPrimitive());
                        return;
                    }
                }
                throw this.invalidConversion(fromType, toType);
            }
            default: {
                throw this.invalidConversion(fromType, toType);
            }
        }
        if (toType.isPrimitive()) {
            if (op != 0) {
                this.addCode(stackAdjust, op);
            }
        } else {
            if (op == 0) {
                this.prebox(toPrimitiveType, toType);
            } else if (!fromPrimitiveType.isDoubleWord() && toPrimitiveType.isDoubleWord()) {
                this.prebox(fromPrimitiveType, toType);
                this.addCode(stackAdjust, op);
            } else {
                this.addCode(stackAdjust, op);
                this.prebox(toPrimitiveType, toType);
            }
            this.box(toPrimitiveType, toType);
        }
    }

    private void unbox(TypeDesc from, TypeDesc to) {
        String methodName;
        switch (to.getTypeCode()) {
            case 4: {
                methodName = "booleanValue";
                break;
            }
            case 5: {
                methodName = "charValue";
                break;
            }
            case 6: {
                methodName = "floatValue";
                break;
            }
            case 7: {
                methodName = "doubleValue";
                break;
            }
            case 8: {
                methodName = "byteValue";
                break;
            }
            case 9: {
                methodName = "shortValue";
                break;
            }
            case 10: {
                methodName = "intValue";
                break;
            }
            case 11: {
                methodName = "longValue";
                break;
            }
            default: {
                return;
            }
        }
        this.invokeVirtual(from.getRootName(), methodName, to, new TypeDesc[0]);
    }

    private void prebox(TypeDesc from, TypeDesc to) {
        switch (from.getTypeCode()) {
            default: {
                break;
            }
            case 4: {
                if (to.toPrimitiveType().getTypeCode() == 4) break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                this.newObject(to);
                this.dupX1();
                this.swap();
                break;
            }
            case 7: 
            case 11: {
                this.newObject(to);
                this.dupX2();
                this.dupX2();
                this.pop();
            }
        }
    }

    private void box(TypeDesc from, TypeDesc to) {
        switch (from.getTypeCode()) {
            case 4: {
                this.toBoolean(true);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                this.invokeConstructor(to.getRootName(), from);
            }
        }
    }

    private void toBoolean(boolean box) {
        Label nonZero = this.createLabel();
        Label done = this.createLabel();
        this.ifZeroComparisonBranch(nonZero, "!=");
        if (box) {
            TypeDesc newType = TypeDesc.forClass(Boolean.class);
            this.loadStaticField(newType.getRootName(), "FALSE", newType);
            this.branch(done);
            nonZero.setLocation();
            this.loadStaticField(newType.getRootName(), "TRUE", newType);
        } else {
            this.loadConstant(false);
            this.branch(done);
            nonZero.setLocation();
            this.loadConstant(true);
        }
        done.setLocation();
    }

    private IllegalArgumentException invalidConversion(TypeDesc from, TypeDesc to) {
        throw new IllegalArgumentException("Invalid conversion: " + from.getFullName() + " to " + to.getFullName());
    }

    public void invoke(Method method) {
        TypeDesc ret = TypeDesc.forClass(method.getReturnType(), method.getGenericReturnType());
        Class<?>[] paramClasses = method.getParameterTypes();
        Type[] paramTypes = method.getGenericParameterTypes();
        TypeDesc[] params = new TypeDesc[paramClasses.length];
        for (int i = 0; i < params.length; ++i) {
            params[i] = TypeDesc.forClass(paramClasses[i], paramTypes[i]);
        }
        Class<?> clazz = method.getDeclaringClass();
        if (Modifier.isStatic(method.getModifiers())) {
            this.invokeStatic(clazz.getName(), method.getName(), ret, params);
        } else if (clazz.isInterface()) {
            this.invokeInterface(clazz.getName(), method.getName(), ret, params);
        } else {
            this.invokeVirtual(clazz.getName(), method.getName(), ret, params);
        }
    }

    public void invoke(Constructor constructor) {
        Class<?>[] paramClasses = constructor.getParameterTypes();
        Type[] paramTypes = constructor.getGenericParameterTypes();
        TypeDesc[] params = new TypeDesc[paramClasses.length];
        for (int i = 0; i < params.length; ++i) {
            params[i] = TypeDesc.forClass(paramClasses[i], paramTypes[i]);
        }
        this.invokeConstructor(constructor.getDeclaringClass().toString(), params);
    }

    @Override
    public void invokeVirtual(String methodName, TypeDesc ret, TypeDesc ... params) {
        ConstantMethodInfo info = this.mCp.addConstantMethod(this.mClassFile.getClassName(), methodName, ret, params);
        int stackAdjust = this.returnSize(ret) - 1;
        if (params != null) {
            stackAdjust -= this.argSize(params);
        }
        this.addCode(stackAdjust, (byte)-74, info);
    }

    @Override
    public void invokeVirtual(String className, String methodName, TypeDesc ret, TypeDesc ... params) {
        ConstantMethodInfo info = this.mCp.addConstantMethod(className, methodName, ret, params);
        int stackAdjust = this.returnSize(ret) - 1;
        if (params != null) {
            stackAdjust -= this.argSize(params);
        }
        this.addCode(stackAdjust, (byte)-74, info);
    }

    @Override
    public void invokeStatic(String methodName, TypeDesc ret, TypeDesc ... params) {
        ConstantMethodInfo info = this.mCp.addConstantMethod(this.mClassFile.getClassName(), methodName, ret, params);
        int stackAdjust = this.returnSize(ret) - 0;
        if (params != null) {
            stackAdjust -= this.argSize(params);
        }
        this.addCode(stackAdjust, (byte)-72, info);
    }

    @Override
    public void invokeStatic(String className, String methodName, TypeDesc ret, TypeDesc ... params) {
        ConstantMethodInfo info = this.mCp.addConstantMethod(className, methodName, ret, params);
        int stackAdjust = this.returnSize(ret) - 0;
        if (params != null) {
            stackAdjust -= this.argSize(params);
        }
        this.addCode(stackAdjust, (byte)-72, info);
    }

    @Override
    public void invokeInterface(String className, String methodName, TypeDesc ret, TypeDesc ... params) {
        ConstantInterfaceMethodInfo info = this.mCp.addConstantInterfaceMethod(className, methodName, ret, params);
        int paramCount = 1;
        if (params != null) {
            paramCount += this.argSize(params);
        }
        int stackAdjust = this.returnSize(ret) - paramCount;
        byte[] bytes = new byte[5];
        bytes[0] = -71;
        bytes[3] = (byte)paramCount;
        InstructionList instructionList = this.mInstructions;
        instructionList.getClass();
        new InstructionList.ConstantOperandInstruction(instructionList, stackAdjust, bytes, info);
    }

    @Override
    public void invokePrivate(String methodName, TypeDesc ret, TypeDesc ... params) {
        ConstantMethodInfo info = this.mCp.addConstantMethod(this.mClassFile.getClassName(), methodName, ret, params);
        int stackAdjust = this.returnSize(ret) - 1;
        if (params != null) {
            stackAdjust -= this.argSize(params);
        }
        this.addCode(stackAdjust, (byte)-73, info);
    }

    @Override
    public void invokeSuper(String superClassName, String methodName, TypeDesc ret, TypeDesc ... params) {
        ConstantMethodInfo info = this.mCp.addConstantMethod(superClassName, methodName, ret, params);
        int stackAdjust = this.returnSize(ret) - 1;
        if (params != null) {
            stackAdjust -= this.argSize(params);
        }
        this.addCode(stackAdjust, (byte)-73, info);
    }

    public void invokeSuper(Method method) {
        TypeDesc ret = TypeDesc.forClass(method.getReturnType(), method.getGenericReturnType());
        Class<?>[] paramClasses = method.getParameterTypes();
        Type[] paramTypes = method.getGenericParameterTypes();
        TypeDesc[] params = new TypeDesc[paramClasses.length];
        for (int i = 0; i < params.length; ++i) {
            params[i] = TypeDesc.forClass(paramClasses[i], paramTypes[i]);
        }
        this.invokeSuper(method.getDeclaringClass().getName(), method.getName(), ret, params);
    }

    @Override
    public void invokeConstructor(TypeDesc ... params) {
        ConstantMethodInfo info = this.mCp.addConstantConstructor(this.mClassFile.getClassName(), params);
        int stackAdjust = -1;
        if (params != null) {
            stackAdjust -= this.argSize(params);
        }
        this.addCode(stackAdjust, (byte)-73, info);
    }

    public void invokeConstructor(MethodInfo mi) {
        this.invokeConstructor(mi.getClassFile().getClassName(), mi.getMethodDescriptor().getParameterTypes());
    }

    @Override
    public void invokeConstructor(String className, TypeDesc ... params) {
        ConstantMethodInfo info = this.mCp.addConstantConstructor(className, params);
        int stackAdjust = -1;
        if (params != null) {
            stackAdjust -= this.argSize(params);
        }
        this.addCode(stackAdjust, (byte)-73, info);
    }

    @Override
    public void invokeSuperConstructor(TypeDesc ... params) {
        this.invokeConstructor(this.mClassFile.getSuperClassName(), params);
    }

    public void invokeSuper(Constructor constructor) {
        Class<?>[] paramClasses = constructor.getParameterTypes();
        Type[] paramTypes = constructor.getGenericParameterTypes();
        TypeDesc[] params = new TypeDesc[paramClasses.length];
        for (int i = 0; i < params.length; ++i) {
            params[i] = TypeDesc.forClass(paramClasses[i], paramTypes[i]);
        }
        this.invokeSuperConstructor(params);
    }

    private int returnSize(TypeDesc ret) {
        if (ret == null || ret == TypeDesc.VOID) {
            return 0;
        }
        if (ret.isDoubleWord()) {
            return 2;
        }
        return 1;
    }

    private int argSize(TypeDesc ... params) {
        int size = 0;
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                size += this.returnSize(params[i]);
            }
        }
        return size;
    }

    @Override
    public void newObject(TypeDesc type) {
        if (type.isArray()) {
            this.newObject(type, 1);
        } else {
            ConstantClassInfo info = this.mCp.addConstantClass(type);
            this.addCode(1, (byte)-69, info);
        }
    }

    @Override
    public void newObject(TypeDesc type, int dimensions) {
        if (dimensions <= 0) {
            ConstantClassInfo info = this.mCp.addConstantClass(type);
            this.addCode(1, (byte)-69, info);
            return;
        }
        TypeDesc componentType = type.getComponentType();
        if (dimensions == 1) {
            if (componentType.isPrimitive()) {
                this.addCode(0, (byte)-68, (byte)componentType.getTypeCode());
                return;
            }
            this.addCode(0, (byte)-67, this.mCp.addConstantClass(componentType));
            return;
        }
        int stackAdjust = -(dimensions - 1);
        ConstantClassInfo info = this.mCp.addConstantClass(type);
        byte[] bytes = new byte[4];
        bytes[0] = -59;
        bytes[3] = (byte)dimensions;
        InstructionList instructionList = this.mInstructions;
        instructionList.getClass();
        new InstructionList.ConstantOperandInstruction(instructionList, stackAdjust, bytes, info);
    }

    @Override
    public void dup() {
        this.addCode(1, (byte)89);
    }

    @Override
    public void dupX1() {
        this.addCode(1, (byte)90);
    }

    @Override
    public void dupX2() {
        this.addCode(1, (byte)91);
    }

    @Override
    public void dup2() {
        this.addCode(2, (byte)92);
    }

    @Override
    public void dup2X1() {
        this.addCode(2, (byte)93);
    }

    @Override
    public void dup2X2() {
        this.addCode(2, (byte)94);
    }

    @Override
    public void pop() {
        this.addCode(-1, (byte)87);
    }

    @Override
    public void pop2() {
        this.addCode(-2, (byte)88);
    }

    @Override
    public void swap() {
        this.addCode(0, (byte)95);
    }

    @Override
    public void swap2() {
        this.dup2X2();
        this.pop2();
    }

    private void branch(int stackAdjust, Location location, byte opcode) {
        InstructionList instructionList = this.mInstructions;
        instructionList.getClass();
        new InstructionList.BranchInstruction(instructionList, stackAdjust, opcode, location);
    }

    @Override
    public void branch(Location location) {
        this.branch(0, location, (byte)-89);
    }

    @Override
    public void ifNullBranch(Location location, boolean choice) {
        this.branch(-1, location, choice ? (byte)-58 : -57);
    }

    @Override
    public void ifEqualBranch(Location location, boolean choice) {
        this.branch(-2, location, choice ? (byte)-91 : -90);
    }

    @Override
    public void ifZeroComparisonBranch(Location location, String choice) throws IllegalArgumentException {
        int opcode;
        if ((choice = choice.intern()) == "==") {
            opcode = -103;
        } else if (choice == "!=") {
            opcode = -102;
        } else if (choice == "<") {
            opcode = -101;
        } else if (choice == ">=") {
            opcode = -100;
        } else if (choice == ">") {
            opcode = -99;
        } else if (choice == "<=") {
            opcode = -98;
        } else {
            throw new IllegalArgumentException("Invalid comparision choice: " + choice);
        }
        this.branch(-1, location, (byte)opcode);
    }

    @Override
    public void ifComparisonBranch(Location location, String choice) throws IllegalArgumentException {
        int opcode;
        if ((choice = choice.intern()) == "==") {
            opcode = -97;
        } else if (choice == "!=") {
            opcode = -96;
        } else if (choice == "<") {
            opcode = -95;
        } else if (choice == ">=") {
            opcode = -94;
        } else if (choice == ">") {
            opcode = -93;
        } else if (choice == "<=") {
            opcode = -92;
        } else {
            throw new IllegalArgumentException("Invalid comparision choice: " + choice);
        }
        this.branch(-2, location, (byte)opcode);
    }

    @Override
    public void switchBranch(int[] cases, Location[] locations, Location defaultLocation) {
        InstructionList instructionList = this.mInstructions;
        instructionList.getClass();
        new InstructionList.SwitchInstruction(instructionList, cases, locations, defaultLocation);
    }

    @Override
    public void jsr(Location location) {
        this.branch(1, location, (byte)-88);
    }

    @Override
    public void ret(LocalVariable local) {
        if (local == null) {
            throw new NullPointerException("No local variable specified");
        }
        InstructionList instructionList = this.mInstructions;
        instructionList.getClass();
        new InstructionList.RetInstruction(instructionList, local);
    }

    @Override
    public void math(byte opcode) {
        int stackAdjust;
        switch (opcode) {
            case 116: 
            case 117: 
            case 118: 
            case 119: {
                stackAdjust = 0;
                break;
            }
            case -128: 
            case -126: 
            case -107: 
            case -106: 
            case 96: 
            case 98: 
            case 100: 
            case 102: 
            case 104: 
            case 106: 
            case 108: 
            case 110: 
            case 112: 
            case 114: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: {
                stackAdjust = -1;
                break;
            }
            case -127: 
            case -125: 
            case 97: 
            case 99: 
            case 101: 
            case 103: 
            case 105: 
            case 107: 
            case 109: 
            case 111: 
            case 113: 
            case 115: 
            case 127: {
                stackAdjust = -2;
                break;
            }
            case -108: 
            case -105: 
            case -104: {
                stackAdjust = -3;
                break;
            }
            default: {
                throw new IllegalArgumentException("Not a math opcode: " + Opcode.getMnemonic(opcode));
            }
        }
        this.addCode(stackAdjust, opcode);
    }

    @Override
    public void arrayLength() {
        this.addCode(0, (byte)-66);
    }

    @Override
    public void throwObject() {
        this.addCode(-1, (byte)-65);
    }

    @Override
    public void checkCast(TypeDesc type) {
        ConstantClassInfo info = this.mCp.addConstantClass(type);
        this.addCode(0, (byte)-64, info);
    }

    @Override
    public void instanceOf(TypeDesc type) {
        ConstantClassInfo info = this.mCp.addConstantClass(type);
        this.addCode(0, (byte)-63, info);
    }

    @Override
    public void integerIncrement(LocalVariable local, int amount) {
        if (local == null) {
            throw new NullPointerException("No local variable specified");
        }
        if (Short.MIN_VALUE <= amount && amount <= Short.MAX_VALUE) {
            InstructionList instructionList = this.mInstructions;
            instructionList.getClass();
            new InstructionList.ShortIncrementInstruction(instructionList, local, (short)amount);
        } else {
            this.loadLocal(local);
            this.loadConstant(amount);
            this.math((byte)96);
            this.storeLocal(local);
        }
    }

    @Override
    public void monitorEnter() {
        this.addCode(-1, (byte)-62);
    }

    @Override
    public void monitorExit() {
        this.addCode(-1, (byte)-61);
    }

    @Override
    public void nop() {
        this.addCode(0, (byte)0);
    }

    @Override
    public void breakpoint() {
        this.addCode(0, (byte)-54);
    }
}

