/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.classfile;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.teatrove.trove.classfile.Attribute;
import org.teatrove.trove.classfile.AttributeFactory;
import org.teatrove.trove.classfile.CodeBuffer;
import org.teatrove.trove.classfile.ConstantPool;
import org.teatrove.trove.classfile.ExceptionHandler;
import org.teatrove.trove.classfile.LineNumberTableAttr;
import org.teatrove.trove.classfile.LocalVariable;
import org.teatrove.trove.classfile.LocalVariableTableAttr;
import org.teatrove.trove.classfile.Location;

public class CodeAttr
extends Attribute {
    private CodeBuffer mCodeBuffer;
    private List mAttributes = new ArrayList(2);
    private LineNumberTableAttr mLineNumberTable;
    private LocalVariableTableAttr mLocalVariableTable;

    CodeAttr(ConstantPool cp) {
        super(cp, "Code");
    }

    public CodeBuffer getCodeBuffer() {
        return this.mCodeBuffer;
    }

    public void setCodeBuffer(CodeBuffer code) {
        this.mCodeBuffer = code;
    }

    public int getLineNumber(Location start) {
        if (this.mLineNumberTable == null || start.getLocation() < 0) {
            return -1;
        }
        return this.mLineNumberTable.getLineNumber(start);
    }

    public void mapLineNumber(Location start, int line_number) {
        if (this.mLineNumberTable == null) {
            this.addAttribute(new LineNumberTableAttr(this.mCp));
        }
        this.mLineNumberTable.addEntry(start, line_number);
    }

    public void localVariableUse(LocalVariable localVar) {
        if (this.mLocalVariableTable == null) {
            this.addAttribute(new LocalVariableTableAttr(this.mCp));
        }
        this.mLocalVariableTable.addEntry(localVar);
    }

    public void addAttribute(Attribute attr) {
        if (attr instanceof LineNumberTableAttr) {
            if (this.mLineNumberTable != null) {
                this.mAttributes.remove(this.mLineNumberTable);
            }
            this.mLineNumberTable = (LineNumberTableAttr)attr;
        } else if (attr instanceof LocalVariableTableAttr) {
            if (this.mLocalVariableTable != null) {
                this.mAttributes.remove(this.mLocalVariableTable);
            }
            this.mLocalVariableTable = (LocalVariableTableAttr)attr;
        }
        this.mAttributes.add(attr);
    }

    @Override
    public Attribute[] getAttributes() {
        Attribute[] attrs = new Attribute[this.mAttributes.size()];
        return this.mAttributes.toArray(attrs);
    }

    @Override
    public int getLength() {
        int length = 12;
        if (this.mCodeBuffer != null) {
            length += this.mCodeBuffer.getByteCodes().length;
            ExceptionHandler[] handlers = this.mCodeBuffer.getExceptionHandlers();
            if (handlers != null) {
                length += 8 * handlers.length;
            }
        }
        int size = this.mAttributes.size();
        for (int i = 0; i < size; ++i) {
            length += ((Attribute)this.mAttributes.get(i)).getLength();
            length += 6;
        }
        return length;
    }

    @Override
    public void writeDataTo(DataOutput dout) throws IOException {
        int i;
        if (this.mCodeBuffer == null) {
            throw new NullPointerException("CodeAttr has no CodeBuffer set");
        }
        ExceptionHandler[] handlers = this.mCodeBuffer.getExceptionHandlers();
        dout.writeShort(this.mCodeBuffer.getMaxStackDepth());
        dout.writeShort(this.mCodeBuffer.getMaxLocals());
        byte[] byteCodes = this.mCodeBuffer.getByteCodes();
        dout.writeInt(byteCodes.length);
        dout.write(byteCodes);
        if (handlers != null) {
            int exceptionHandlerCount = handlers.length;
            dout.writeShort(exceptionHandlerCount);
            for (i = 0; i < exceptionHandlerCount; ++i) {
                handlers[i].writeTo(dout);
            }
        } else {
            dout.writeShort(0);
        }
        int size = this.mAttributes.size();
        dout.writeShort(size);
        for (i = 0; i < size; ++i) {
            Attribute attr = (Attribute)this.mAttributes.get(i);
            attr.writeTo(dout);
        }
    }

    static Attribute define(ConstantPool cp, String name, int length, DataInput din, AttributeFactory attrFactory) throws IOException {
        CodeAttr code = new CodeAttr(cp);
        final int maxStackDepth = din.readUnsignedShort();
        final int maxLocals = din.readUnsignedShort();
        final byte[] byteCodes = new byte[din.readInt()];
        din.readFully(byteCodes);
        int exceptionHandlerCount = din.readUnsignedShort();
        final ExceptionHandler[] handlers = new ExceptionHandler[exceptionHandlerCount];
        for (int i = 0; i < exceptionHandlerCount; ++i) {
            handlers[i] = ExceptionHandler.readFrom(cp, din);
        }
        code.mCodeBuffer = new CodeBuffer(){

            @Override
            public int getMaxStackDepth() {
                return maxStackDepth;
            }

            @Override
            public int getMaxLocals() {
                return maxLocals;
            }

            @Override
            public byte[] getByteCodes() {
                return (byte[])byteCodes.clone();
            }

            @Override
            public ExceptionHandler[] getExceptionHandlers() {
                return (ExceptionHandler[])handlers.clone();
            }
        };
        int attributeCount = din.readUnsignedShort();
        for (int i = 0; i < attributeCount; ++i) {
            code.addAttribute(Attribute.readFrom(cp, din, attrFactory));
        }
        return code;
    }
}

