/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.classfile;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teatrove.trove.classfile.Attribute;
import org.teatrove.trove.classfile.AttributeFactory;
import org.teatrove.trove.classfile.ClassFileDataLoader;
import org.teatrove.trove.classfile.CodeBuilder;
import org.teatrove.trove.classfile.ConstantClassInfo;
import org.teatrove.trove.classfile.ConstantInfo;
import org.teatrove.trove.classfile.ConstantPool;
import org.teatrove.trove.classfile.DeprecatedAttr;
import org.teatrove.trove.classfile.FieldInfo;
import org.teatrove.trove.classfile.InnerClassesAttr;
import org.teatrove.trove.classfile.MethodDesc;
import org.teatrove.trove.classfile.MethodInfo;
import org.teatrove.trove.classfile.Modifiers;
import org.teatrove.trove.classfile.SignatureAttr;
import org.teatrove.trove.classfile.SignatureDesc;
import org.teatrove.trove.classfile.SourceFileAttr;
import org.teatrove.trove.classfile.SyntheticAttr;
import org.teatrove.trove.classfile.TypeDesc;
import org.teatrove.trove.classfile.generics.GenericTypeFactory;
import org.teatrove.trove.classfile.generics.TypeVariableDesc;

public class ClassFile {
    private static final int MAGIC = -889275714;
    private static final int JDK1_1_MAJOR_VERSION = 50;
    private static final int JDK1_1_MINOR_VERSION = 0;
    private int mMajorVersion = 50;
    private int mMinorVersion = 0;
    private final String mClassName;
    private final String mSuperClassName;
    private String mInnerClassName;
    private TypeDesc mType;
    private ConstantPool mCp;
    private Modifiers mModifiers;
    private ConstantClassInfo mThisClass;
    private ConstantClassInfo mSuperClass;
    private List mInterfaces = new ArrayList(2);
    private Set mInterfaceSet = new HashSet(7);
    private List mFields = new ArrayList();
    private List mMethods = new ArrayList();
    private List mAttributes = new ArrayList();
    private SourceFileAttr mSource;
    private List mInnerClasses;
    private int mAnonymousInnerClassCount = 0;
    private InnerClassesAttr mInnerClassesAttr;
    private ClassFile mOuterClass;
    private Set<Class<?>> mParentClasses = new HashSet();

    public ClassFile(String className) {
        this(className, (String)null);
    }

    public ClassFile(String className, Class superClass) {
        this(className, superClass.getName());
        this.mParentClasses.add(superClass);
    }

    public ClassFile(String className, String superClassName) {
        if (superClassName == null && !className.equals(Object.class.getName())) {
            superClassName = Object.class.getName();
        }
        this.mCp = new ConstantPool();
        this.mModifiers = new Modifiers(1);
        this.mThisClass = ConstantClassInfo.make(this.mCp, className);
        this.mSuperClass = ConstantClassInfo.make(this.mCp, superClassName);
        this.mClassName = className;
        this.mSuperClassName = superClassName;
    }

    private ClassFile(ConstantPool cp, Modifiers modifiers, ConstantClassInfo thisClass, ConstantClassInfo superClass, ClassFile outerClass) {
        this.mCp = cp;
        this.mModifiers = modifiers;
        this.mThisClass = thisClass;
        this.mSuperClass = superClass;
        this.mClassName = thisClass.getType().getRootName();
        this.mSuperClassName = superClass == null ? null : superClass.getType().getRootName();
        this.mOuterClass = outerClass;
    }

    public String getClassName() {
        return this.mClassName;
    }

    public String getSuperClassName() {
        return this.mSuperClassName;
    }

    public TypeDesc getType() {
        if (this.mType == null) {
            this.mType = TypeDesc.forClass(this.mClassName);
        }
        return this.mType;
    }

    public Modifiers getModifiers() {
        return this.mModifiers;
    }

    public String[] getInterfaces() {
        int size = this.mInterfaces.size();
        String[] names = new String[size];
        for (int i = 0; i < size; ++i) {
            names[i] = ((ConstantClassInfo)this.mInterfaces.get(i)).getType().getRootName();
        }
        return names;
    }

    public FieldInfo[] getFields() {
        FieldInfo[] fields = new FieldInfo[this.mFields.size()];
        return this.mFields.toArray(fields);
    }

    public MethodInfo[] getMethods() {
        int size = this.mMethods.size();
        ArrayList<MethodInfo> methodsOnly = new ArrayList<MethodInfo>(size);
        for (int i = 0; i < size; ++i) {
            MethodInfo method = (MethodInfo)this.mMethods.get(i);
            String name = method.getName();
            if ("<init>".equals(name) || "<clinit>".equals(name)) continue;
            methodsOnly.add(method);
        }
        MethodInfo[] methodsArray = new MethodInfo[methodsOnly.size()];
        return methodsOnly.toArray(methodsArray);
    }

    public MethodInfo[] getConstructors() {
        int size = this.mMethods.size();
        ArrayList<MethodInfo> ctorsOnly = new ArrayList<MethodInfo>(size);
        for (int i = 0; i < size; ++i) {
            MethodInfo method = (MethodInfo)this.mMethods.get(i);
            if (!"<init>".equals(method.getName())) continue;
            ctorsOnly.add(method);
        }
        MethodInfo[] ctorsArray = new MethodInfo[ctorsOnly.size()];
        return ctorsOnly.toArray(ctorsArray);
    }

    public MethodInfo getInitializer() {
        int size = this.mMethods.size();
        for (int i = 0; i < size; ++i) {
            MethodInfo method = (MethodInfo)this.mMethods.get(i);
            if (!"<clinit>".equals(method.getName())) continue;
            return method;
        }
        return null;
    }

    public ClassFile[] getInnerClasses() {
        if (this.mInnerClasses == null) {
            return new ClassFile[0];
        }
        ClassFile[] innerClasses = new ClassFile[this.mInnerClasses.size()];
        return this.mInnerClasses.toArray(innerClasses);
    }

    public boolean isInnerClass() {
        return this.mOuterClass != null;
    }

    public String getInnerClassName() {
        return this.mInnerClassName;
    }

    public ClassFile getOuterClass() {
        return this.mOuterClass;
    }

    public int getClassDepth() {
        int depth = 0;
        ClassFile outer = this.mOuterClass;
        while (outer != null) {
            ++depth;
            outer = outer.mOuterClass;
        }
        return depth;
    }

    public String getSourceFile() {
        if (this.mSource == null) {
            return null;
        }
        return this.mSource.getFileName();
    }

    public boolean isSynthetic() {
        int i = this.mAttributes.size();
        while (--i >= 0) {
            Object obj = this.mAttributes.get(i);
            if (!(obj instanceof SyntheticAttr)) continue;
            return true;
        }
        return false;
    }

    public boolean isDeprecated() {
        int i = this.mAttributes.size();
        while (--i >= 0) {
            Object obj = this.mAttributes.get(i);
            if (!(obj instanceof DeprecatedAttr)) continue;
            return true;
        }
        return false;
    }

    public ConstantPool getConstantPool() {
        return this.mCp;
    }

    public void addInterface(String interfaceName) {
        if (!this.mInterfaceSet.contains(interfaceName)) {
            this.mInterfaces.add(ConstantClassInfo.make(this.mCp, interfaceName));
            this.mInterfaceSet.add(interfaceName);
        }
    }

    public void addInterface(Class i) {
        this.addInterface(i.getName());
        this.mParentClasses.add(i);
    }

    public FieldInfo addField(Modifiers modifiers, String fieldName, TypeDesc type) {
        FieldInfo fi = new FieldInfo(this, modifiers, fieldName, type);
        this.mFields.add(fi);
        return fi;
    }

    public MethodInfo addMethod(Modifiers modifiers, String methodName, TypeDesc ret, TypeDesc ... params) {
        return this.addMethod(modifiers, methodName, (TypeVariableDesc[])null, ret, params);
    }

    public MethodInfo addMethod(Modifiers modifiers, String methodName, TypeVariableDesc[] typeParams, TypeDesc ret, TypeDesc[] params) {
        MethodDesc md = MethodDesc.forArguments(ret, params);
        SignatureDesc sd = SignatureDesc.forMethod(typeParams, ret, params);
        return this.addMethod(modifiers, methodName, md, sd);
    }

    public MethodInfo addMethod(Modifiers modifiers, String methodName, TypeDesc ret, TypeDesc[] params, String[] paramNames) {
        return this.addMethod(modifiers, methodName, null, ret, params, paramNames);
    }

    public MethodInfo addMethod(Modifiers modifiers, String methodName, TypeVariableDesc[] typeParams, TypeDesc ret, TypeDesc[] params, String[] paramNames) {
        MethodDesc md = MethodDesc.forArguments(ret, params, paramNames);
        SignatureDesc sd = SignatureDesc.forMethod(typeParams, ret, params);
        return this.addMethod(modifiers, methodName, md, sd);
    }

    public MethodInfo addMethod(Modifiers modifiers, String methodName, MethodDesc md, SignatureDesc sd) {
        MethodInfo mi = new MethodInfo(this, modifiers, methodName, md, sd);
        this.mMethods.add(mi);
        return mi;
    }

    public MethodInfo addMethod(Method method) {
        Modifiers modifiers = new Modifiers(method.getModifiers());
        modifiers.setAbstract(this.getModifiers().isInterface());
        TypeVariableDesc[] typeParams = this.lookupTypeVariables(method);
        TypeDesc ret = TypeDesc.forClass(method.getReturnType(), method.getGenericReturnType());
        MethodDescriptor methodDescriptor = ClassFile.lookupMethodDescriptor(method);
        Class<?>[] paramClasses = method.getParameterTypes();
        Type[] paramTypes = method.getGenericParameterTypes();
        TypeDesc[] params = new TypeDesc[paramClasses.length];
        String[] paramNames = new String[paramClasses.length];
        for (int i = 0; i < paramClasses.length; ++i) {
            params[i] = TypeDesc.forClass(paramClasses[i], paramTypes[i]);
            paramNames[i] = methodDescriptor != null ? methodDescriptor.getParameterDescriptors()[i].getName() : "param$" + i;
        }
        MethodInfo mi = this.addMethod(modifiers, method.getName(), typeParams, ret, params, paramNames);
        Class<?>[] exceptions = method.getExceptionTypes();
        for (int i = 0; i < exceptions.length; ++i) {
            mi.addException(exceptions[i].getName());
        }
        return mi;
    }

    public MethodInfo addMethod(Method method, Class<?> returnType, Class<?> ... paramClasses) {
        Modifiers modifiers = new Modifiers(method.getModifiers());
        modifiers.setAbstract(this.getModifiers().isInterface());
        TypeVariableDesc[] typeParams = this.lookupTypeVariables(method);
        TypeDesc ret = TypeDesc.forClass(returnType, method.getGenericReturnType());
        MethodDescriptor methodDescriptor = ClassFile.lookupMethodDescriptor(method);
        Type[] paramTypes = method.getGenericParameterTypes();
        TypeDesc[] params = new TypeDesc[paramClasses.length];
        String[] paramNames = new String[paramClasses.length];
        for (int i = 0; i < paramClasses.length; ++i) {
            params[i] = TypeDesc.forClass(paramClasses[i], paramTypes[i]);
            paramNames[i] = methodDescriptor != null ? methodDescriptor.getParameterDescriptors()[i].getName() : "param$" + i;
        }
        MethodInfo mi = this.addMethod(modifiers, method.getName(), typeParams, ret, params, paramNames);
        Class<?>[] exceptions = method.getExceptionTypes();
        for (int i = 0; i < exceptions.length; ++i) {
            mi.addException(exceptions[i].getName());
        }
        return mi;
    }

    private TypeVariableDesc[] lookupTypeVariables(Method method) {
        TypeVariable<GenericDeclaration>[] cargs;
        LinkedHashMap<String, TypeVariableDesc> args = new LinkedHashMap<String, TypeVariableDesc>();
        boolean valid = false;
        Class<?> declaringClass = method.getDeclaringClass();
        for (Class<?> clazz : this.mParentClasses) {
            if (!declaringClass.isAssignableFrom(clazz)) continue;
            valid = true;
            break;
        }
        if (!valid) {
            for (TypeVariable<GenericDeclaration> carg : cargs = declaringClass.getTypeParameters()) {
                args.put(carg.getName(), (TypeVariableDesc)GenericTypeFactory.fromType(carg));
            }
        }
        for (TypeVariable<GenericDeclaration> carg : cargs = method.getTypeParameters()) {
            args.remove(carg.getName());
            args.put(carg.getName(), (TypeVariableDesc)GenericTypeFactory.fromType(carg));
        }
        return args.values().toArray(new TypeVariableDesc[args.size()]);
    }

    private static MethodDescriptor lookupMethodDescriptor(Method method) {
        MethodDescriptor methodDescriptor = null;
        try {
            for (MethodDescriptor methodDescriptor1 : Introspector.getBeanInfo(method.getDeclaringClass()).getMethodDescriptors()) {
                if (methodDescriptor1.getMethod() != method) continue;
                methodDescriptor = methodDescriptor1;
                break;
            }
        }
        catch (IntrospectionException e) {
            throw new RuntimeException("Unable to find MethodDescriptor for method " + method, e);
        }
        return methodDescriptor;
    }

    public MethodInfo addConstructor(Modifiers modifiers, TypeDesc ... params) {
        String[] paramNames = MethodDesc.createGenericParameterNames(params);
        return this.addConstructor(modifiers, params, paramNames);
    }

    public MethodInfo addConstructor(Modifiers modifiers, TypeDesc[] params, String[] paramNames) {
        MethodDesc md = MethodDesc.forArguments(null, params, paramNames);
        MethodInfo mi = new MethodInfo(this, modifiers, "<init>", md, null);
        this.mMethods.add(mi);
        return mi;
    }

    public MethodInfo addDefaultConstructor() {
        Modifiers modifiers = new Modifiers();
        modifiers.setPublic(true);
        MethodInfo mi = this.addConstructor(modifiers, (TypeDesc[])null, (String[])null);
        CodeBuilder builder = new CodeBuilder(mi);
        builder.loadThis();
        builder.invokeSuperConstructor(new TypeDesc[0]);
        builder.returnVoid();
        return mi;
    }

    public MethodInfo addInitializer() {
        MethodDesc md = MethodDesc.forArguments(null, null, null);
        Modifiers af = new Modifiers();
        af.setStatic(true);
        MethodInfo mi = new MethodInfo(this, af, "<clinit>", md, null);
        this.mMethods.add(mi);
        return mi;
    }

    public ClassFile addInnerClass(String innerClassName) {
        return this.addInnerClass(innerClassName, (String)null);
    }

    public ClassFile addInnerClass(String innerClassName, Class superClass) {
        return this.addInnerClass(innerClassName, superClass.getName());
    }

    public ClassFile addInnerClass(String innerClassName, String superClassName) {
        String fullInnerClassName = innerClassName == null ? this.mClassName + '$' + ++this.mAnonymousInnerClassCount : this.mClassName + '$' + innerClassName;
        ClassFile inner = new ClassFile(fullInnerClassName, superClassName);
        Modifiers access = inner.getModifiers();
        access.setPrivate(true);
        access.setStatic(true);
        inner.mInnerClassName = innerClassName;
        inner.mOuterClass = this;
        if (this.mInnerClasses == null) {
            this.mInnerClasses = new ArrayList();
        }
        this.mInnerClasses.add(inner);
        if (this.mInnerClassesAttr == null) {
            this.addAttribute(new InnerClassesAttr(this.mCp));
        }
        this.mInnerClassesAttr.addInnerClass(fullInnerClassName, this.mClassName, innerClassName, access);
        inner.addAttribute(new InnerClassesAttr(inner.getConstantPool()));
        inner.mInnerClassesAttr.addInnerClass(fullInnerClassName, this.mClassName, innerClassName, access);
        return inner;
    }

    public void setSourceFile(String fileName) {
        this.addAttribute(new SourceFileAttr(this.mCp, fileName));
    }

    public void setSignature(String signature) {
        this.addAttribute(new SignatureAttr(this.mCp, signature));
    }

    public void markSynthetic() {
        this.addAttribute(new SyntheticAttr(this.mCp));
    }

    public void markDeprecated() {
        this.addAttribute(new DeprecatedAttr(this.mCp));
    }

    public void addAttribute(Attribute attr) {
        if (attr instanceof SourceFileAttr) {
            if (this.mSource != null) {
                this.mAttributes.remove(this.mSource);
            }
            this.mSource = (SourceFileAttr)attr;
        } else if (attr instanceof InnerClassesAttr) {
            if (this.mInnerClassesAttr != null) {
                this.mAttributes.remove(this.mInnerClassesAttr);
            }
            this.mInnerClassesAttr = (InnerClassesAttr)attr;
        }
        this.mAttributes.add(attr);
    }

    public Attribute[] getAttributes() {
        Attribute[] attrs = new Attribute[this.mAttributes.size()];
        return this.mAttributes.toArray(attrs);
    }

    public void setVersion(int major, int minor) throws IllegalArgumentException {
        if (major != 50 || minor != 0) {
            throw new IllegalArgumentException("Version " + major + ", " + minor + " is not supported");
        }
        this.mMajorVersion = major;
        this.mMinorVersion = minor;
    }

    public void writeTo(OutputStream out) throws IOException {
        if (!(out instanceof DataOutput)) {
            out = new DataOutputStream(out);
        }
        this.writeTo((DataOutput)((Object)out));
        out.flush();
    }

    public void writeTo(DataOutput dout) throws IOException {
        int i;
        dout.writeInt(-889275714);
        dout.writeShort(this.mMinorVersion);
        dout.writeShort(this.mMajorVersion);
        this.mCp.writeTo(dout);
        int modifier = this.mModifiers.getModifier();
        if (!this.mModifiers.isInterface()) {
            modifier |= 0x20;
        }
        dout.writeShort(modifier);
        dout.writeShort(this.mThisClass.getIndex());
        if (this.mSuperClass != null) {
            dout.writeShort(this.mSuperClass.getIndex());
        } else {
            dout.writeShort(0);
        }
        int size = this.mInterfaces.size();
        if (size > 65535) {
            throw new RuntimeException("Interfaces count cannot exceed 65535: " + size);
        }
        dout.writeShort(size);
        for (i = 0; i < size; ++i) {
            int index = ((ConstantInfo)this.mInterfaces.get(i)).getIndex();
            dout.writeShort(index);
        }
        size = this.mFields.size();
        if (size > 65535) {
            throw new RuntimeException("Field count cannot exceed 65535: " + size);
        }
        dout.writeShort(size);
        for (i = 0; i < size; ++i) {
            FieldInfo field = (FieldInfo)this.mFields.get(i);
            field.writeTo(dout);
        }
        size = this.mMethods.size();
        if (size > 65535) {
            throw new RuntimeException("Method count cannot exceed 65535: " + size);
        }
        dout.writeShort(size);
        for (i = 0; i < size; ++i) {
            MethodInfo method = (MethodInfo)this.mMethods.get(i);
            method.writeTo(dout);
        }
        size = this.mAttributes.size();
        if (size > 65535) {
            throw new RuntimeException("Attribute count cannot exceed 65535: " + size);
        }
        dout.writeShort(size);
        for (i = 0; i < size; ++i) {
            Attribute attr = (Attribute)this.mAttributes.get(i);
            attr.writeTo(dout);
        }
    }

    public static ClassFile readFrom(InputStream in) throws IOException {
        return ClassFile.readFrom(in, null, null);
    }

    public static ClassFile readFrom(DataInput din) throws IOException {
        return ClassFile.readFrom(din, null, null);
    }

    public static ClassFile readFrom(InputStream in, ClassFileDataLoader loader, AttributeFactory attrFactory) throws IOException {
        if (!(in instanceof DataInput)) {
            in = new DataInputStream(in);
        }
        return ClassFile.readFrom((DataInput)((Object)in), loader, attrFactory);
    }

    public static ClassFile readFrom(DataInput din, ClassFileDataLoader loader, AttributeFactory attrFactory) throws IOException {
        return ClassFile.readFrom(din, loader, attrFactory, new HashMap(11), null);
    }

    private static ClassFile readFrom(DataInput din, ClassFileDataLoader loader, AttributeFactory attrFactory, Map loadedClassFiles, ClassFile outerClass) throws IOException {
        int i;
        int magic = din.readInt();
        if (magic != -889275714) {
            throw new IOException("Incorrect magic number: 0x" + Integer.toHexString(magic));
        }
        din.readUnsignedShort();
        din.readUnsignedShort();
        ConstantPool cp = ConstantPool.readFrom(din);
        Modifiers modifiers = new Modifiers(din.readUnsignedShort());
        modifiers.setSynchronized(false);
        int index = din.readUnsignedShort();
        ConstantClassInfo thisClass = (ConstantClassInfo)cp.getConstant(index);
        index = din.readUnsignedShort();
        ConstantClassInfo superClass = null;
        if (index > 0) {
            superClass = (ConstantClassInfo)cp.getConstant(index);
        }
        ClassFile cf = new ClassFile(cp, modifiers, thisClass, superClass, outerClass);
        loadedClassFiles.put(cf.getClassName(), cf);
        int size = din.readUnsignedShort();
        for (i = 0; i < size; ++i) {
            index = din.readUnsignedShort();
            ConstantClassInfo info = (ConstantClassInfo)cp.getConstant(index);
            cf.addInterface(info.getType().getRootName());
        }
        size = din.readUnsignedShort();
        for (i = 0; i < size; ++i) {
            cf.mFields.add(FieldInfo.readFrom(cf, din, attrFactory));
        }
        size = din.readUnsignedShort();
        for (i = 0; i < size; ++i) {
            cf.mMethods.add(MethodInfo.readFrom(cf, din, attrFactory));
        }
        size = din.readUnsignedShort();
        for (i = 0; i < size; ++i) {
            Attribute attr = Attribute.readFrom(cp, din, attrFactory);
            cf.addAttribute(attr);
            if (!(attr instanceof InnerClassesAttr)) continue;
            cf.mInnerClassesAttr = (InnerClassesAttr)attr;
        }
        if (cf.mInnerClassesAttr != null && loader != null) {
            InnerClassesAttr.Info[] infos = cf.mInnerClassesAttr.getInnerClassesInfo();
            for (int i2 = 0; i2 < infos.length; ++i2) {
                ClassFile innerClass;
                ConstantClassInfo inner;
                InnerClassesAttr.Info info = infos[i2];
                if (thisClass.equals(info.getInnerClass())) {
                    if (info.getInnerClassName() != null) {
                        cf.mInnerClassName = info.getInnerClassName();
                    }
                    ConstantClassInfo outer = info.getOuterClass();
                    if (cf.mOuterClass == null && outer != null) {
                        cf.mOuterClass = ClassFile.readOuterClass(outer, loader, attrFactory, loadedClassFiles);
                    }
                    Modifiers innerFlags = info.getModifiers();
                    modifiers.setStatic(innerFlags.isStatic());
                    modifiers.setPrivate(innerFlags.isPrivate());
                    modifiers.setProtected(innerFlags.isProtected());
                    modifiers.setPublic(innerFlags.isPublic());
                    continue;
                }
                if (!thisClass.equals(info.getOuterClass()) || (inner = info.getInnerClass()) == null || (innerClass = ClassFile.readInnerClass(inner, loader, attrFactory, loadedClassFiles, cf)) == null) continue;
                if (innerClass.getInnerClassName() == null) {
                    innerClass.mInnerClassName = info.getInnerClassName();
                }
                if (cf.mInnerClasses == null) {
                    cf.mInnerClasses = new ArrayList();
                }
                cf.mInnerClasses.add(innerClass);
            }
        }
        return cf;
    }

    private static ClassFile readOuterClass(ConstantClassInfo outer, ClassFileDataLoader loader, AttributeFactory attrFactory, Map loadedClassFiles) throws IOException {
        String name = outer.getType().getRootName();
        ClassFile outerClass = (ClassFile)loadedClassFiles.get(name);
        if (outerClass != null) {
            return outerClass;
        }
        InputStream in = loader.getClassData(name);
        if (in == null) {
            return null;
        }
        if (!(in instanceof DataInput)) {
            in = new DataInputStream(in);
        }
        return ClassFile.readFrom((DataInput)((Object)in), loader, attrFactory, loadedClassFiles, null);
    }

    private static ClassFile readInnerClass(ConstantClassInfo inner, ClassFileDataLoader loader, AttributeFactory attrFactory, Map loadedClassFiles, ClassFile outerClass) throws IOException {
        String name = inner.getType().getRootName();
        ClassFile innerClass = (ClassFile)loadedClassFiles.get(name);
        if (innerClass != null) {
            return innerClass;
        }
        InputStream in = loader.getClassData(name);
        if (in == null) {
            return null;
        }
        if (!(in instanceof DataInput)) {
            in = new DataInputStream(in);
        }
        return ClassFile.readFrom((DataInput)((Object)in), loader, attrFactory, loadedClassFiles, outerClass);
    }
}

