/*
 * Decompiled with CFR 0.152.
 */
package nf.fr.eraasoft.pool;

import nf.fr.eraasoft.pool.ObjectPool;
import nf.fr.eraasoft.pool.PoolableObject;
import nf.fr.eraasoft.pool.impl.PoolControler;
import nf.fr.eraasoft.pool.impl.PoolFactory;

public class PoolSettings<T> {
    public static final int DEFAUL_MAX_WAIT = 5;
    public static final int DEFAULT_MIN = 1;
    public static final int DEFAULT_MAX = 10;
    public static final int DEFAULT_TIME_BETWEEN_TWO_CONTROLE = 30;
    private static int TIME_BETWEEN_TWO_CONTROLE = 30;
    private int maxWait = 5;
    private int min = 1;
    private int max = 10;
    private int maxIdle = this.min;
    private boolean validateWhenReturn = false;
    private boolean debug = false;
    private final PoolFactory<T> poolFactory;

    public static void timeBetweenTwoControls(int time) {
        TIME_BETWEEN_TWO_CONTROLE = time;
    }

    public static int timeBetweenTwoControls() {
        return TIME_BETWEEN_TWO_CONTROLE;
    }

    public PoolSettings(PoolableObject<T> poolableObject) {
        this.poolFactory = new PoolFactory<T>(this, poolableObject);
        PoolControler.addPoolSettings(this);
    }

    public ObjectPool<T> pool() {
        return this.poolFactory.getPool();
    }

    public PoolSettings<T> maxIdle(int maxIdle) {
        this.maxIdle = maxIdle < this.min ? this.min : maxIdle;
        return this;
    }

    public int maxIdle() {
        return this.maxIdle;
    }

    public PoolSettings<T> maxWait(int maxWait) {
        this.maxWait = maxWait;
        return this;
    }

    public PoolSettings<T> min(int min) {
        this.min = min;
        this.maxIdle = min;
        if (this.max > 0 && min > this.max) {
            this.max(min);
        }
        return this;
    }

    public PoolSettings<T> max(int max) {
        this.max = max;
        if (max > 0 && max < this.min) {
            this.min(max);
        }
        return this;
    }

    public int min() {
        return this.min;
    }

    public int maxWait() {
        return this.maxWait;
    }

    public int max() {
        return this.max;
    }

    public static void shutdown() {
        PoolControler.shutdown();
    }

    public PoolSettings<T> validateWhenReturn(boolean validateWhenReturn) {
        this.validateWhenReturn = validateWhenReturn;
        return this;
    }

    public boolean validateWhenReturn() {
        return this.validateWhenReturn;
    }

    public PoolSettings<T> debug(boolean debug) {
        this.debug = debug;
        return this;
    }

    public boolean debug() {
        return this.debug;
    }

    public void clearCurrentPool() {
        this.poolFactory.clear();
    }
}

