/*
 * Decompiled with CFR 0.152.
 */
package benchmark;

import benchmark.ResultFile;
import benchmark.ResultGroup;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Results {
    Map<String, Map<String, Map<String, Set<ResultFile>>>> results = new HashMap<String, Map<String, Map<String, Set<ResultFile>>>>();

    public void add(ResultFile result) {
        Map<String, Set<ResultFile>> bucketAlgorithm;
        Map<String, Map<String, Set<ResultFile>>> bucketDataset;
        if (!this.results.containsKey(result.dataset)) {
            this.results.put(result.dataset, new HashMap());
        }
        if (!(bucketDataset = this.results.get(result.dataset)).containsKey(result.order)) {
            bucketDataset.put(result.order, new HashMap());
        }
        if (!(bucketAlgorithm = bucketDataset.get(result.order)).containsKey(result.algorithm)) {
            bucketAlgorithm.put(result.algorithm, new HashSet());
        }
        bucketAlgorithm.get(result.algorithm).add(result);
    }

    public void process() {
        for (Map<String, Map<String, Set<ResultFile>>> a : this.results.values()) {
            for (Map<String, Set<ResultFile>> b : a.values()) {
                for (Set<ResultFile> set : b.values()) {
                    ResultGroup group = new ResultGroup();
                    for (ResultFile result : set) {
                        for (String key : result.values.keySet()) {
                            group.add(String.valueOf(result.type) + ": " + key, result.values.get(key));
                        }
                    }
                    group.process();
                }
            }
        }
    }

    public String toString() {
        return "Results{results=" + this.results + '}';
    }

    public void output() {
        for (String dataSet : this.results.keySet()) {
            Map<String, Map<String, Set<ResultFile>>> a = this.results.get(dataSet);
            for (String order : a.keySet()) {
                Map<String, Set<ResultFile>> b = a.get(order);
                for (String algorithm : b.keySet()) {
                    Set<ResultFile> set = b.get(algorithm);
                    ResultGroup group = new ResultGroup();
                    for (ResultFile result : set) {
                        for (String key : result.values.keySet()) {
                            group.add(String.valueOf(result.type) + ":" + key, result.values.get(key));
                        }
                    }
                    group.process();
                    for (String key : group.values.keySet()) {
                        ResultGroup.ValueGroup valueGroup = group.values.get(key);
                        System.out.println(String.valueOf(dataSet) + " \t " + order + " \t " + algorithm + " \t \"" + key + "\" \t " + valueGroup.output(key));
                    }
                }
            }
        }
    }
}

