/*
 * Decompiled with CFR 0.152.
 */
package benchmark;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class ResultGroup {
    HashMap<String, ValueGroup> values = new HashMap();

    public void add(String key, Long value) {
        if (!this.values.containsKey(key)) {
            this.values.put(key, new ValueGroup());
        }
        this.values.get(key).add(value);
    }

    public void process() {
        for (ValueGroup group : this.values.values()) {
            group.process();
        }
    }

    public String toString() {
        return "ResultGroup{values=" + this.values + '}';
    }

    public class ValueGroup {
        List<Long> values = new ArrayList<Long>();
        Double avg;
        Double avgSek;
        Double avgMb;
        double stdAbweichung;
        private double geom = 1.0;
        private List<Long> outliers;
        private Double avgWithoutOutliers;
        private Double avgWithoutOutliersSek;
        Double geomSek;
        private double med;
        Double medSek;
        Double minSek;

        public void add(Long value) {
            this.values.add(value);
        }

        public void process() {
            double cnt = this.values.size();
            long sum = 0L;
            for (Long v : this.values) {
                sum += v.longValue();
                this.geom *= (double)v.longValue();
            }
            this.avg = new Double((double)sum / cnt);
            this.geom = Math.pow(this.geom, 1.0 / cnt);
            Collections.sort(this.values);
            this.med = this.values.get((int)(cnt / 2.0)).longValue();
            sum = 0L;
            for (Long v : this.values) {
                sum = (long)((double)sum + ((double)v.longValue() - this.avg) * ((double)v.longValue() - this.avg));
            }
            this.stdAbweichung = Math.sqrt((double)sum / cnt);
            this.outliers = new ArrayList<Long>();
            sum = 0L;
            for (Long v : this.values) {
                if ((double)v.longValue() < this.avg - 1.5 * this.stdAbweichung || (double)v.longValue() > this.avg + 1.5 * this.stdAbweichung) {
                    this.outliers.add(v);
                    continue;
                }
                sum += v.longValue();
            }
            this.avgWithoutOutliers = new Double((double)sum / (cnt - (double)this.outliers.size()));
            this.avgSek = new Double(this.avg / 1000.0);
            this.geomSek = new Double(this.geom / 1000.0);
            this.minSek = new Double(this.values.get(0) / 1000L);
            this.medSek = new Double(this.med / 1000.0);
            this.avgWithoutOutliersSek = new Double(this.avgWithoutOutliers / 1000.0);
            this.avgMb = new Double(this.avg / 1024.0);
        }

        public String toString() {
            return this.formatTex(this.avgSek);
        }

        private String formatTex(Double value) {
            return String.format("%.1f", value);
        }

        public String output(String key) {
            if (key.contains("(space)")) {
                return this.formatTex(this.avgMb);
            }
            return String.valueOf(this.formatTex(this.avgSek)) + "\t" + this.formatTex(this.avgWithoutOutliersSek) + "\t" + this.formatTex(this.geomSek) + "\t" + this.formatTex(this.medSek) + "\t" + this.formatTex(this.minSek) + "\t" + this.stdAbweichung + "\t" + this.outliers + "\t" + this.values;
        }
    }
}

