/*
 * Decompiled with CFR 0.152.
 */
package benchmark;

import benchmark.ResultFile;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ResultFileAdaptiveRanging
extends ResultFile {
    protected String range;
    protected String dop;

    @Override
    protected String getFilename() {
        return String.valueOf(this.algorithm) + "_" + this.type + "_" + this.order + "_" + this.dataset + "_" + this.dop + "_" + this.range + "_" + this.run + ".txt";
    }

    public static ResultFileAdaptiveRanging fromFileNameParts(String[] parts) {
        ResultFileAdaptiveRanging tmp = new ResultFileAdaptiveRanging();
        tmp.algorithm = parts[0];
        tmp.order = parts[1];
        tmp.type = parts[2];
        tmp.dataset = parts[3];
        tmp.run = parts[6];
        tmp.dop = parts[4];
        tmp.range = parts[5];
        return tmp;
    }

    @Override
    public String toString() {
        return "ResultFileAdaptiveRanging{type='" + this.type + '\'' + ", order='" + this.order + '\'' + ", algorithm='" + this.algorithm + '\'' + ", dataset='" + this.dataset + '\'' + ", run='" + this.run + '\'' + ", range='" + this.range + '\'' + ", dop='" + this.dop + '\'' + ", values=" + this.values + '}';
    }

    @Override
    public void addContent(List<String> lines) {
        this.values = new HashMap();
        for (String line : lines) {
            String[] contents;
            if (!this.type.equals("space") && line.contains(":::")) {
                contents = line.split(":::");
                long runtime = Long.parseLong(contents[1]);
                this.values.put(this.removeAlgorithmFromKeyString(contents[0]), runtime);
            }
            if (!this.type.equals("space") || !line.contains("(kb):")) continue;
            contents = line.split("\\(kb\\):");
            long space = Long.parseLong(contents[1].trim());
            this.values.put(this.removeAlgorithmFromKeyString(String.valueOf(contents[0]) + "(space)"), space);
        }
        Long buildup = 0L;
        List<String> buildupKey = Arrays.asList("build prefix tree 1 -- build up phase", "build prefix tree 1 -- completion", "build prefix tree 2");
        List<String> removalKey = Arrays.asList(" s.a.t.l.f.FlatTreeCreatorRightSideDirect - build tree", " s.a.t.l.f.FlatTreeCreatorLeftSideDirect - build tree", "sorting");
        for (String k : buildupKey) {
            if (!this.values.containsKey(k)) continue;
            buildup = buildup + (Long)this.values.get(k);
            this.values.remove(k);
        }
        this.values.put("buildup", buildup);
        this.values.put("search", (Long)this.values.get("execute") - buildup);
        for (String k : removalKey) {
            this.values.remove(k);
        }
    }

    private String removeAlgorithmFromKeyString(String key) {
        Object[] contents = key.split("INFO ");
        if (contents.length == 2) {
            key = contents[1];
        }
        if ((contents = key.split(String.valueOf(this.algorithm) + ":")).length < 2) {
            return key;
        }
        return StringUtils.join(contents, ":", 1, contents.length).trim();
    }

    public static /* bridge */ /* synthetic */ ResultFile fromFileNameParts(String[] stringArray) {
        return ResultFileAdaptiveRanging.fromFileNameParts(stringArray);
    }
}

