/*
 * Decompiled with CFR 0.152.
 */
package benchmark;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ResultFile {
    protected String type;
    protected String order;
    protected String algorithm;
    protected String dataset;
    protected String run;
    protected HashMap<String, Long> values;

    protected String getFilename() {
        return String.valueOf(this.algorithm) + "_" + this.type + "_" + this.order + "_" + this.dataset + "_" + this.run + ".txt";
    }

    public static ResultFile fromFileNameParts(String[] parts) {
        ResultFile tmp = new ResultFile();
        tmp.algorithm = parts[0];
        tmp.order = parts[1];
        tmp.type = parts[2];
        tmp.dataset = parts[3];
        tmp.run = parts[4];
        return tmp;
    }

    public String toString() {
        return "SingleResult{type='" + this.type + '\'' + ", order='" + this.order + '\'' + ", algorithm='" + this.algorithm + '\'' + ", dataset='" + this.dataset + '\'' + ", run='" + this.run + '\'' + ", values=" + this.values + '}';
    }

    public void addContent(List<String> lines) {
        this.values = new HashMap();
        for (String line : lines) {
            String[] contents;
            if (!this.type.equals("space") && line.contains(":::")) {
                contents = line.split(":::");
                long runtime = Long.parseLong(contents[1]);
                this.values.put(this.removeAlgorithmFromKeyString(contents[0]), runtime);
            }
            if (!this.type.equals("space") || !line.contains("(kb):")) continue;
            contents = line.split("\\(kb\\):");
            long space = Long.parseLong(contents[1].trim());
            this.values.put(this.removeAlgorithmFromKeyString(String.valueOf(contents[0]) + "(space)"), space);
        }
    }

    private String removeAlgorithmFromKeyString(String key) {
        Object[] contents = key.split("INFO ");
        if (contents.length == 2) {
            key = contents[1];
        }
        if ((contents = key.split(String.valueOf(this.algorithm) + ":")).length < 2) {
            return key;
        }
        return StringUtils.join(contents, ":", 1, contents.length).trim();
    }
}

