/*
 * Decompiled with CFR 0.152.
 */
package benchmark;

import benchmark.ResultFile;
import benchmark.ResultFileAdaptiveRanging;
import benchmark.Results;
import benchmark.ResultsAdaptiveRanging;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class FileReader {
    private final Results resultSet;

    public static void main(String[] args) {
        new FileReader(args[0]);
    }

    public FileReader(String foldername) {
        this.resultSet = this.isAdaptive(foldername) ? new ResultsAdaptiveRanging() : new Results();
        this.readFolder(foldername);
        this.resultSet.output();
    }

    public boolean isAdaptive(String foldername) {
        return foldername.contains("adaptive");
    }

    private void readFolder(String foldername) {
        File folder = new File(foldername);
        File[] files = folder.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isFile()) {
                this.readFile(files[i], foldername);
            }
            ++i;
        }
    }

    private void readFile(File file, String foldername) {
        String[] parts = file.getName().split("\\.");
        if (parts.length == 2 && parts[1].equals("txt")) {
            parts = parts[0].split("_");
            try {
                ResultFile result = this.isAdaptive(foldername) ? ResultFileAdaptiveRanging.fromFileNameParts(parts) : ResultFile.fromFileNameParts(parts);
                result.addContent(this.read(file));
                this.resultSet.add(result);
            }
            catch (Exception e) {
                System.out.println(String.valueOf(file.getName()) + " -> ");
                e.printStackTrace();
            }
        }
    }

    private List<String> read(File file) {
        ArrayList<String> contents = new ArrayList<String>();
        try {
            String line;
            BufferedReader br = new BufferedReader(new java.io.FileReader(file.getAbsoluteFile()));
            while ((line = br.readLine()) != null) {
                contents.add(line);
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return contents;
    }
}

