package scj.algorithm.twotrees.labeling.statistical;

import java.util.Set;

import scj.SystemSetup;
import scj.algorithm.tree.encoded.PIETree;
import scj.algorithm.twotrees.base.BaseTreeCreator;
import scj.SystemSetup.TREE_TYPE;
import scj.input.DataTuple;
import scj.order.SortOrder;
import scj.algorithm.tree.Node;
import scj.algorithm.tree.TreeNode;
import scj.algorithm.tree.encoded.TTIntervalNode;

public class EncodedTreeCreator extends BaseTreeCreator {
	
	@Override
	protected Node createTree(Set<DataTuple> data, SortOrder sortOrder, TREE_TYPE type) {
		if(type == SystemSetup.TREE_TYPE.OuterTree) {
			return getEncodedPrefixTree(data, sortOrder);
		} else {
			return getPrefixTree(data, sortOrder, type);
		}
		
	}

	private Node getEncodedPrefixTree(Set<DataTuple> data, SortOrder sortOrder) {
		return new PIETree(getPrefixTree(data, sortOrder, SystemSetup.TREE_TYPE.OuterTree));
	}

	protected Node getPrefixTree(Set<DataTuple> data, SortOrder sortOrder, TREE_TYPE type) {
		TreeNode rootNode = getTreeNode(TreeNode.DEFAULT_VALUE, type);
		for(DataTuple date: data) {
			//Go to the matching position
			Node traverser = rootNode;
			Node tmp;
			for(int contentElement: date.getSet()) {
				tmp = traverser.getChild(contentElement);
				if(tmp == null) {
					tmp = getTreeNode(contentElement, type);
					traverser.addChild(tmp);
				}
				traverser = tmp;
			}
			traverser.addContent(date.getId());
			
		}
		
		return rootNode;
	}

	protected TreeNode getTreeNode(int contentElement, TREE_TYPE type) {
		if(type == SystemSetup.TREE_TYPE.OuterTree) {
			return new TTIntervalNode(contentElement);
		}
		return new TreeNode(contentElement);
	}
	
}
