package scj.algorithm.twotrees.labeling.statistical;

import java.util.Set;

import scj.SystemSetup;
import scj.algorithm.twotrees.Search;
import scj.algorithm.twotrees.TwoTreesAlgorithm;
import scj.algorithm.twotrees.base.BaseTraversal;
import scj.algorithm.twotrees.base.BaseTreeCreator;
import scj.input.DataTuple;
import scj.order.InverseFrequencyOrder;
import scj.result.Result;
import scj.algorithm.tree.Node;

public class EncodedStatistical extends BaseTraversal {

	public EncodedStatistical() {
		sortOrder = new InverseFrequencyOrder();
	}
	
	public String toString() {
		return this.getClass().getName()+".order"+this.sortOrder;
	}
	
	protected TwoTreesAlgorithm getTraversalAlgorithm() {
		return new EncodedAlgorithm();
	}

	@Override
	public void preexecute(Set<DataTuple> set1, Set<DataTuple> set2, Result result) {
		sortOrder.initialize(set2);
		for(DataTuple r : set1) {
			sortOrder.sort(r.getSet());
		}

		for(DataTuple r : set2) {
			sortOrder.sort(r.getSet());
		}
	}

	@Override
	public void execute(Set<DataTuple> n_a, Set<DataTuple> n_b, Result result) {

	}

	class EncodedAlgorithm implements TwoTreesAlgorithm {
		@Override
		public void execute(Node n_a, Node n_b, Result result) {
			Search search = new EncodedSearch(n_a, n_b, result);
			result = search.search();
		}
	}
	
	protected BaseTreeCreator getTreeCreator(final Set<DataTuple> n_a, final SystemSetup.TREE_TYPE type) {
		return new EncodedTreeCreator() {
			public Object execute() {
				return this.createTree(n_a, sortOrder, type);
			}
		};
	}
}
