package scj.algorithm.twotrees.labeling.statistical;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import scj.algorithm.tree.encoded.PIETree;
import scj.algorithm.twotrees.Search;
import scj.analyze.statistics.StatisticValue;
import scj.result.Result;
import scj.algorithm.tree.Node;
import scj.algorithm.tree.TreeNode;


public class EncodedSearch implements Search {

	private static final Logger LOGGER = LoggerFactory.getLogger(EncodedSearch.class);
	
	protected Node a;
	protected Result result;
	protected StatisticValue numOfCalls;

	private PIETree S;

	public EncodedSearch(Node n_a, Node n_b, Result result) {
		this.a = n_a;
		this.S = (PIETree) n_b;
		this.result = result;
	}

	@Override
	public Result search() {
		this.numOfCalls = new StatisticValue(0);
		this.search(a, 1);
		System.out.println("No. of calls on 'search': "+numOfCalls.getValue());
		
		return result;
	}
	
	public String toString() {
		return a + "\n" + S;
	}
	
	/*
	 * Search.
	 */	
	protected void search(Node n_r, int scope_start) {
		this.numOfCalls.add(1);		
		
		IntList content_r = ((TreeNode) n_r).getTupleIds();
		if (!content_r.isEmpty()) {
			lookForOutput(content_r, scope_start);
		}

		// Traversal
		for (Node c_r : n_r.getChildren()) {
			IntList result = S.findRanges(c_r.getName(), scope_start);
			IntListIterator resultItr = result.iterator();
			while(resultItr.hasNext()) {
				search(c_r, resultItr.nextInt());
			}
		}
	}

	private void lookForOutput(IntList content_r, int scope_start) {
		
		// Build set of results on right side
		IntCollection result_s = S.getIdsByPosition(scope_start, S.getRangeEnd(scope_start));
		
		IntListIterator it_r = content_r.iterator();
		while(it_r.hasNext()) {
			int nextInt = it_r.nextInt();
			IntIterator it_s = result_s.iterator();
			while(it_s.hasNext()) {
				result.add(nextInt, it_s.nextInt());				
			}
		}		
	}
}
