package scj.analyze.visualize;

import java.util.Set;

import scj.BenchmarkExecutor;
import scj.Executor;
import scj.algorithm.ConfigurableRawDataAlgorithm;
import scj.algorithm.RawDataAlgorithm;
import scj.algorithm.twotrees.labeling.sa.LabelingSA;
import scj.algorithm.twotrees.labeling.sa.EncodedTreeCreator;
import scj.analyze.Analyzer;
import scj.input.DataTuple;
import scj.order.SortOrder;
import scj.result.CountResultList;
import scj.result.Result;
import scj.algorithm.tree.Node;

public class Visualizer extends Analyzer {

	public Visualizer(RawDataAlgorithm algorithm) {
		super(algorithm);
	}

	public static void main(String[] args) {

		Executor.MODE = Executor.EXECUTION_MODE.Space; // Do not do the actual join

		final SortOrder order = getSortOrder(args);

		ConfigurableRawDataAlgorithm alg = new LabelingSA();
		
		if (alg instanceof scj.algorithm.twotrees.base.BaseTraversal) {
			((scj.algorithm.twotrees.base.BaseTraversal) alg)
					.setSortOrder(order);
		}
		
		
		Executor exec = new BenchmarkExecutor(alg);

		Result r = new CountResultList(alg.getClass().getName());

		final Set<DataTuple>[] data = getDataSets(args);
		exec.preexecute(data[0], data[1], r);

		Node tree = (Node) new EncodedTreeCreator() {
			public Object execute() {
				return this.createTree(data[0], order, TREE_TYPE.InnerTree);
			}
		}.execute();
		
		DotVis vis = new DotVis();
		vis.visualize(tree, order);

	}
}
