package scj.analyze.visualize;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import scj.order.SortOrder;
import scj.algorithm.tree.Node;

public class DotVis {
	
	List<IntList> data;
	
	int zoom_x = 8, zoom_y = 10000;
	
	SortOrder order;

	public void visualize(Node tree, SortOrder order) {
		
		data = new ArrayList<IntList>();
		
		this.order = order;
		
		vis(tree, 0, 0);
		
		for(int x = 0;x < data.size(); x++) {
			IntList line = data.get(x);
			for(int y = 0; y < line.size(); y++) {
				//TODO display different items depending on value
				System.out.print(line.get(y) > 0 ? (line.get(y) > 500 ? "X": "x"): " ");
			}
			System.out.println();
		}
		
	}

	private int vis(Node tree, int level, int offset) {
		
		int display_level = (int) Math.floor(level / zoom_x);
		int display_offset = (int) Math.floor(offset / zoom_y);
		
		if(data.size()-1 < display_level) {
			data.add(display_level, new IntArrayList());
		}
		
		IntList levelData = data.get(display_level);
		if(levelData.size()-1 < display_offset) {
			for(int i = levelData.size(); i <= display_offset; i++) {
				levelData.add(i, 0);
			}
		}
		
		levelData.set(display_offset, levelData.get(display_offset)+tree.getTupleIds().size());
		
		int o = Integer.valueOf(offset);
		
		//Sort children by frequency (for display only)
		Collection<Node> child = tree.getChildren();
		List<Node> childList = this.order.sort(child);
		
		for(Node c: childList) {
			o = vis(c, level + 1, o) + 1;
		}
		
		return o;
		
	}

}
