package scj.analyze.statistics.tree.output;

import java.util.Collection;
import java.util.List;

import scj.analyze.statistics.tree.StatisticsTreeNode;
import scj.order.SortOrder;
import scj.algorithm.tree.Node;

public class FirstLevelOutput implements StatisticsOutput {

	public void output(Node tree, SortOrder order) {
		Collection<Node> child = tree.getChildren();
		List<Node> childList = order.sort(child);
		
		int i=0;
		for(Node n : childList) {
			System.out.println(
						i++
						+"\t"+((StatisticsTreeNode) n).getNumNodes()
						+"\t"+((StatisticsTreeNode) n).getNumTuples()
						+"\t"+((StatisticsTreeNode) n).getPathLength());
		}
	}
}
