package scj.analyze.statistics.tree;

import java.util.Set;

import scj.BenchmarkExecutor;
import scj.Executor;
import scj.algorithm.ConfigurableRawDataAlgorithm;
import scj.algorithm.RawDataAlgorithm;
import scj.algorithm.twotrees.labeling.sa.LabelingSA;
import scj.analyze.Analyzer;
import scj.analyze.statistics.tree.output.RootLevelOutput;
import scj.analyze.statistics.tree.output.StatisticsOutput;
import scj.input.DataTuple;
import scj.order.SortOrder;
import scj.result.CountResultList;
import scj.result.Result;
import scj.algorithm.tree.Node;


/**
 * Die Größe des Präfixbaums ist stark abhängig von der Sortierung der Mengenelemente. 
 * MFU erzeugt kompaktere Bäume mit weniger Knoten, da Knoten mit demselben Namen häufiger 
 * (inbesondere in den oberen Ebenen) zusammengefasst werden.
 * So erzeugt der bms-Datensatz bei MFU 1.622.827 Knoten im Präfixbaum, bei LFU hingegen 2.402.368.
 *
 */
public class TreeStatisticGenerator extends Analyzer {

	public TreeStatisticGenerator(RawDataAlgorithm algorithm) {
		super(algorithm);
	}

	public static void main(String[] args) {

		// Read arguments.
		final SortOrder order 		= getSortOrder(args);
		final Set<DataTuple>[] data = getDataSets(args);
		
		// Choose configuration.
		ConfigurableRawDataAlgorithm alg = new LabelingSA();
		StatisticsOutput outputGenerator = new RootLevelOutput();
		
		// Execute.
		if (alg instanceof scj.algorithm.twotrees.base.BaseTraversal) {
			((scj.algorithm.twotrees.base.BaseTraversal) alg)
					.setSortOrder(order);
		}
		
		Executor exec = new BenchmarkExecutor(alg);

		Result r = new CountResultList(alg.getClass().getName());
		exec.preexecute(data[0], data[1], r);

		Node tree = (Node) new StatisticsTreeCreator().execute(data[0], order);		
		outputGenerator.output(tree, order);
	}


}
