package scj.analyze.statistics.tree;

import java.util.Collection;

import scj.analyze.statistics.StatisticValue;
import scj.algorithm.tree.Node;
import scj.algorithm.tree.TreeNode;

public class StatisticsTreeNode extends TreeNode {

	protected StatisticValue numNodes;
	protected StatisticValue numTuples;
	protected StatisticValue pathLength;
	
	public StatisticsTreeNode(int contentElement) {
		super(contentElement);
	}

	public void createStatistics() {
		Collection<Node> children = this.getChildren();
		
		this.numNodes = new StatisticValue(1);
//		this.numTuples = new StatisticValue(children.size());
//		this.pathLength = new StatisticValue(0);
		for(Node n : this.getChildren()) {
			((StatisticsTreeNode) n).createStatistics();
			
			this.numNodes.add(((StatisticsTreeNode) n).getNumNodes());
//			this.numTuples.add(((StatisticsTreeNode) n).getNumTuples());
//			this.pathLength.max(((StatisticsTreeNode) n).getPathLength());
		}
		this.pathLength.add(1);
		
		this.numNodes.gatherStatistics(children);
//		this.numTuples.gatherStatistics(children);
//		this.pathLength.gatherStatistics(children);
		
	}

	public int getPathLength() {
		return this.pathLength.getValue();
	}

	public int getNumNodes() {
		return this.numNodes.getValue();
	}
	
	public int getNumTuples() {
		return this.numTuples.getValue();
	}

}
