package scj.analyze.statistics.tree;

import java.util.Set;

import scj.SystemSetup;
import scj.SystemSetup.TREE_TYPE;
import scj.algorithm.twotrees.labeling.sa.EncodedTreeCreator;
import scj.input.DataTuple;
import scj.order.SortOrder;
import scj.algorithm.tree.Node;
import scj.algorithm.tree.TreeNode;

public class StatisticsTreeCreator extends EncodedTreeCreator{
	
	protected TreeNode getTreeNode(int contentElement, TREE_TYPE type) {
		return new StatisticsTreeNode(contentElement);
	}

	public Object execute() {
		return null;
	}
	public Node execute(Set<DataTuple> set, SortOrder order) {
		StatisticsTreeNode tmp = (StatisticsTreeNode) this.createTree(set, order, SystemSetup.TREE_TYPE.InnerTree);
		tmp.createStatistics();
		return tmp;
	}
}