package scj.analyze.statistics.source.counter;



/**
 * 
 * (02.09.)
 * Dataset: netflix
Tool: scj.analyze.statistics.source.FrequentItemCounter
	 0.05 	 0.1 	 0.15 	 0.2 	 0.25 	 0.3 	 0.4 	 0.5 	 0.6 	 0.7 	 0.8 	 0.9 
	 64.28	 45.83	 33.75	 22.78	 12.8	 6.71	 1.23	 0	 0	 0	 0	 0
Tool: scj.analyze.statistics.source.InfrequentItemCounterByValue
	 0.1 	 0.2 	 0.3 	 0.4 	 0.5 	 0.6 	 0.7 	 0.8 	 0.9 
	 0.08	 0.61	 1.06	 1.45	 1.83	 2.15	 2.47	 2.76	 3.07
Tool: scj.analyze.statistics.source.InfrequentItemCounterByPercent
	 0.01 	 0.02 	 0.05 	 0.1 	 0.15 	 0.2 	 0.25 	 0.3 	 0.4 	 0.5 
	 12.26	 19.92	 35.72	 54.17	 66.25	 77.22	 87.2	 93.29	 98.77	 100
	 
	 12% aller Mengenelemente tauchen in höchstens 1% der Mengen auf.
	 
 *
 * "Anteil der Mengenelemente an der Gesamtmenge, welche in höchstens x% der Mengen enthalten sind"
 * Wählt man x=1, so ergibt sich ein klares Bild: Während für bms, flickr und kosarak jeweils über 20% (20%, 80%, 63%) 
 * der Mengenelemente in höchstens 1% der Mengen vorkommen, so sind es bei netflix nur 12%. 
 * 
 * These: zu viele seltene Einträge lassen LFU zu sehr zerfasern.
 */
public class InfrequentItemCounterByPercent extends InfrequentItemCounter {

	// Property.
	protected double[] percentages = new double[]{.01, .02, .05, .1, .15, .2, .25, .3, .4, .5};
	

	protected double getThreshold(double percentage) {
		return percentage * setCount;
	}

	protected double[] getPercentages() {
		return percentages;
	}

}
