package scj.analyze.statistics.source.counter;

import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;

import java.util.Iterator;
import java.util.Map.Entry;

import scj.input.DataTuple;

public class FrequencyCounter implements Counter {

	// Simple stats.
	protected int itemCount;
	protected int setCount;
	protected Int2IntMap countMap;
	
	// Aggregated stats.
	protected double avgSetSize;
	protected Int2IntMap frequencyMap;
	protected int infrequentItemCount;
	protected double threshold;
	protected double infrequentItemPercentage;
	
	public FrequencyCounter() {
		itemCount = 0;
		setCount = 0;
		countMap = new Int2IntOpenHashMap();
	}
	
	public void count(DataTuple tuple) {
		setCount += 1;
		itemCount += tuple.getSet().length;
		
		for(int val: tuple.getSet()) {
			addToCountingMap(countMap, val);
		}
		
	}

	protected void addToCountingMap(Int2IntMap countMap, int val) {
		if(countMap.containsKey(val)) {
			countMap.put(val, 1 + countMap.get(val));
		} else {
			countMap.put(val, 1);
		}
	}

	public void aggregate() {
		
		// Build averages
		avgSetSize = ((double) itemCount) / setCount;
		
		// Build frequency map ("histogram")
		initFrequencyMap();
		
		for (Iterator<Entry<Integer, Integer>> iterator = countMap.entrySet().iterator(); 
				iterator.hasNext();) {
			Entry<Integer, Integer> entry = iterator.next();
			addToCountingMap(frequencyMap, entry.getValue());
		}
		
		// What to do with the histogram?
		// "in den ersten x%" "ob in den ersten oder letzten 10% mehr daten sind".
		// "in den ersten 10".
		//FIXME
		threshold = .15 * setCount; //"10% der sets"
		/*
		 * Als Indikator für die Verteilung der Mengenelemente auf die einzelnen Mengen kann gewählt werden: 
		 * 	"Anteil der Mengenelemente an der Gesamtmenge, welche in höchstens x% der Mengen enthalten sind"
		 * bzw.
		 * 	"Anteil der Mengenelemente an der Gesamtmenge, welche in mehr als x% der Mengen enthalten sind".
		 * Hier zeigt sich, dass die 4 Datensätze sich in diesem Indikator deutlich unterscheiden. 
		 * Während bms, flickr und kosarak alle einen hohen Anteil an Mengenelementen haben, 
		 * welche oft auftauchen, ist dieser bei netflix geringer.
		 * 
		 * Tabelle:
		 * 
		 * bms			
		 * flickr
		 * kosarak
		 * netflix
		 */
		
		
		infrequentItemCount = 0;		
		for (Iterator<Entry<Integer, Integer>> iterator = frequencyMap.entrySet().iterator(); 
				iterator.hasNext();) {
			Entry<Integer, Integer> entry = iterator.next();
			
			if(entry.getKey() <= threshold) {
				infrequentItemCount += entry.getValue()*entry.getKey();
			}
		}
		
		infrequentItemPercentage = ((double) infrequentItemCount) / itemCount;
	}

	protected void initFrequencyMap() {
		frequencyMap = new Int2IntOpenHashMap();
	}

	public String output() {
		StringBuilder tmp = new StringBuilder();
		
		tmp.append("Number of items: "+itemCount+"\n");
		tmp.append("Number of sets: "+setCount+"\n");
		tmp.append("Average set size: "+avgSetSize+"\n");
		tmp.append("Number of items appearing at max "+threshold+" times: "+infrequentItemCount+"\n");
		tmp.append("Percentage of items appearing at max "+threshold+" times: "+infrequentItemPercentage+"\n");
		
		return tmp.toString();
	}

}
