package scj.analyze.statistics.source;

import java.util.Set;

import scj.algorithm.RawDataAlgorithm;
import scj.analyze.Analyzer;
import scj.analyze.statistics.source.counter.Counter;
import scj.analyze.statistics.source.counter.FrequentItemCounterByPercent;
import scj.analyze.statistics.source.counter.InfrequentItemCounterByPercent;
import scj.analyze.statistics.source.counter.InfrequentItemCounterByValue;
import scj.input.DataTuple;

/**
 * 
 * In einem ersten Schritt werde ich die Generierung der <x> Thesen vorstellen. 
 * Diese basiert auf den 4 Datensätze bms, flickr, kosarak und netflix. Im zweiten 
 * Schritt werde ich diese auf Daten verifizieren bzw. falsifizieren, welche ich 
 * aus dem PubMed-Reactome-Datensatz generiere. Anschließend werde ich die verifizierten Thesen in eine zusammenhängende Formel fügen, (...)
 * 
 * 
 * 
 *
 */
public class SourceDataStatisticGenerator extends Analyzer {

	public SourceDataStatisticGenerator(RawDataAlgorithm algorithm) {
		super(algorithm);
	}

	public static void main(String[] args) {

		//work(args);
		work(new String[]{"bms-pos"});
		work(new String[]{"flickr"});
		work(new String[]{"kosarak"});
		work(new String[]{"netflix"});
		
	}

	protected static void work(String[] args) {
		System.out.println("\nDataset: "+args[0]);
		// Read arguments.
		final Set<DataTuple>[] data = getDataSets(args);
		
		// Take statistic you want to do.
		Counter[] tools = new Counter[]{
					new FrequentItemCounterByPercent(), 
					new InfrequentItemCounterByValue(), 
					new InfrequentItemCounterByPercent()
		};
		
		for(Counter tool : tools) {
			// Do statistics.
			for(DataTuple tuple: data[0]) {
				tool.count(tuple);
			}
			tool.aggregate();
			
			// Output.
			System.out.println("Tool: "+tool.getClass().getName());
			System.out.println(tool.output());
		}
	}


	protected static Set<DataTuple>[] getDataSets(String[] args) {
		final int argsOffset = 0;
		return getDataTuplesByOffset(args, argsOffset);
	}

}
