package scj.analyze.statistics.source;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

import scj.algorithm.RawDataAlgorithm;
import scj.analyze.Analyzer;
import scj.analyze.statistics.source.counter.Counter;
import scj.analyze.statistics.source.counter.FrequentItemCounterByPercent;
import scj.analyze.statistics.source.counter.InfrequentItemCounterByPercent;
import scj.input.DataTuple;

/**
 * 
 * 
 * Idee: Nimm nur jede x-te Zeile aus einem Datensatz und gucke, ob sich die Verhältnisse verändern.
 *
 */
public class ChangingSetSizeStatisticGenerator extends Analyzer {

	public ChangingSetSizeStatisticGenerator(RawDataAlgorithm algorithm) {
		super(algorithm);
	}

	public static void main(String[] args) {

		//work(args);
		work(new String[]{"bms-pos"});
//		work(new String[]{"flickr"});
//		work(new String[]{"kosarak"});
//		work(new String[]{"netflix"});
		
	}

	protected static void work(String[] args) {
		// Take statistic you want to do.
		
		
		System.out.println("\nDataset: "+args[0]);
		// Read arguments.
		Set<DataTuple>[] data = getDataSets(args);
		
		
		List<DataTuple> dataList = new ArrayList<DataTuple>(data[0]);
		int listSize = dataList.size();
		Collections.shuffle(dataList);

		System.out.println("\nDataset size: "+(100)+"% | "+dataList.size());
		doStatistics(dataList);
		
		int step = 20;
		for(int i=1;i<=100/step;i++) {
			for(int j=0;j<listSize/100*step && dataList.size()>0;j++) {
				dataList.remove(dataList.size()-1);
			}
			System.out.println("\nDataset size: "+(100-i*step)+"% | "+dataList.size());
			doStatistics(dataList);
			
		}
	}

	protected static void doStatistics(final Collection<DataTuple> data) {
		Counter[] tools = new Counter[]{
				new FrequentItemCounterByPercent(), 
//				new InfrequentItemCounterByValue(), 
//				new InfrequentItemCounterByPercent()
		};
		
		for(Counter tool : tools) {
			// Do statistics.
			for(DataTuple tuple: data) {
				tool.count(tuple);
			}
			tool.aggregate();
			
			// Output.
			System.out.println("Tool: "+tool.getClass().getName());
			System.out.println(tool.output());
		}
	}


	protected static Set<DataTuple>[] getDataSets(String[] args) {
		final int argsOffset = 0;
		return getDataTuplesByOffset(args, argsOffset);
	}

}
