package scj.analyze.statistics.execution;

import java.util.Set;

import scj.BenchmarkExecutor;
import scj.Executor;
import scj.algorithm.ConfigurableRawDataAlgorithm;
import scj.algorithm.RawDataAlgorithm;
import scj.algorithm.twotrees.labeling.statistical.EncodedStatistical;
import scj.analyze.Analyzer;
import scj.input.DataTuple;
import scj.order.SortOrder;
import scj.result.CountResultList;
import scj.result.Result;


public class ExecutionStatistics extends Analyzer {

	public ExecutionStatistics(RawDataAlgorithm algorithm) {
		super(algorithm);
		Executor.MODE = Executor.EXECUTION_MODE.Time; // Do not do the actual join
	}

	public static void main(String[] args) {

		// Read arguments.
		final SortOrder order 		= getSortOrder(args);
		final Set<DataTuple>[] data = getDataSets(args);
		
		// Choose configuration.
		ConfigurableRawDataAlgorithm alg = new EncodedStatistical();
//		StatisticsOutput outputGenerator = new FirstLevelOutput();
		
		// Execute.
		if (alg instanceof scj.algorithm.twotrees.base.BaseTraversal) {
			((scj.algorithm.twotrees.base.BaseTraversal) alg)
					.setSortOrder(order);
		}	
		
		Executor exec = new BenchmarkExecutor(alg);

		Result r = new CountResultList(alg.getClass().getName());
		exec.preexecute(data[0], data[1], r);
		exec.execute(data[0], data[1], r);

		r.output();
//		Node tree = (Node) new StatisticsTreeCreator().execute(data[0], order);		
//		outputGenerator.output(tree, order);
	}


}
