package scj.analyze;

import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Set;

import scj.SystemSetup;
import scj.input.DataTuple;

public class Histogram extends SystemSetup {

	public static void writeToFile(String filename, Int2IntMap histogram) {

		try {
			PrintWriter out = new PrintWriter(filename);
			try {
				for (int key : histogram.keySet()) {
					out.println(key + "\t" + histogram.get(key));
				}
			} finally {
				out.close();
			}
		} catch (IOException ex) {
			System.err.println(ex);
		}
	}

	public static void main(String[] args) {
		Set<DataTuple> data = readFile(args[0], -1)[0];
		Int2IntMap histogram = new Int2IntOpenHashMap();

		// Fill histogram
		for (DataTuple date : data) {
			for (int contentElement : date.getSet()) {
				if (histogram.containsKey(contentElement)) {
					histogram.put(contentElement,
							histogram.get(contentElement) + 1);
				} else {
					histogram.put(contentElement, 1);
				}
			}
		}

		writeToFile("histogram_"+args[0], histogram);

	}

}
