package scj.analyze;

import java.util.Set;

import scj.Executor;
import scj.algorithm.RawDataAlgorithm;
import scj.input.DataTuple;
import scj.order.SortOrder;

public abstract class Analyzer extends Executor {

	protected static SortOrder getSortOrder(String[] args) {
		final int argsOffset = 0;
		return getSortOrderByOffset(args, argsOffset);
	}

	protected static Set<DataTuple>[] getDataSets(String[] args) {
		final int argsOffset = 1;
		return getDataTuplesByOffset(args, argsOffset);
	}


	public Analyzer(RawDataAlgorithm algorithm) {
		super(algorithm);
		
		Executor.MODE = Executor.EXECUTION_MODE.Space; // Do not do the actual join
	}

}