#!/bin/bash
# Config
workspace=~/workspace_new/scj
jarname=scj-twoprefixtrees-0.1-SNAPSHOT.jar

path=generated_data

# Provide directory
mkdir $path
cp $workspace/target/$jarname $path

# #Tuples: 2^16 bis 2^21
# Max#Items: 2^6 bis 2^16
# MaxItem: 2^10 bis 2^20

setDists=(zipf)
domDists=(zipf)

#\dataset{KOSARAK} & 990\,002 & 41\,270 & 2\,497 & 8.10 & 30.1\\

# Execute
for setDist in ${setDists[@]}
do 
	for domDist in ${domDists[@]}
	do
		relationSize=$((2**20))
		domCard=$((2**15))
		setCard=$((2**11))
		for ((i=1;i<=5;i++))
		do
			filename="$path/gen_"$relationSize"_"$setCard"_"$setDist"_"$domCard"_"$domDist"_"$i".inp"
			if [ ! -f $filename ]; then
				echo $relationSize $setCard $setDist $domCard $domDist
				java -Xss8m -Xmx25g -classpath $path/$jarname scj.input.datagenerator.DataGenerator $relationSize $setCard $setDist $domCard $domDist > $filename
			fi
		done

	done
done
