#!/bin/bash
# Config
workspace=~/workspace_new/scj
jarname=scj-twoprefixtrees-0.1-SNAPSHOT.jar

path=generated_data

# Provide directory
mkdir $path
cp $workspace/target/$jarname $path

# #Tuples: 2^16 bis 2^21
# Max#Items: 2^6 bis 2^16
# MaxItem: 2^10 bis 2^20

setDists=(zipf)
domDists=(zipf)

# Execute
for setDist in ${setDists[@]}
do 
	for domDist in ${domDists[@]}
	do
		for ((relationSize=2**16; relationSize <=2**21; relationSize=relationSize * 2))
		do
			for ((domCard=2**10; domCard <= 2**15; domCard = domCard * 2))
			do
				for ((setCard=2**5; setCard <= 2**10; setCard=setCard * 2))
				do
					filename="$path/gen_"$relationSize"_"$setCard"_"$setDist"_"$domCard"_"$domDist"_1.inp"
					if [ ! -f $filename ]; then
						java -Xss8m -Xmx10g -classpath $path/$jarname scj.input.datagenerator.DataGenerator $relationSize $setCard $setDist $domCard $domDist > $filename
					fi
				done
			done
		done
	done
done
