package scj;

import java.util.Set;

import scj.algorithm.RawDataAlgorithm;
import scj.algorithm.twotrees.labeling.sa.LabelingSA;
import scj.input.DataTuple;
import scj.input.datagenerator.DataGenerator;
import scj.input.datagenerator.DataGenerator.Distribution;
import scj.order.FrequencyOrder;
import scj.order.InverseFrequencyOrder;
import scj.order.SortOrder;
import scj.result.CountResultList;
import scj.result.Result;
import scj.runtime.RuntimeCalculator;

/**
 * Die Relationen werden in einem ersten separaten Schritt generiert und in Dateien abgelegt. Auf diese Weise 
 * werden für alle Berechnungen dieselben Daten genutzt, so dass keine Verfälschungen auftreten durch 
 * unterschiedliche Daten (gleichwohl mit gleichen Charakteristiken).
 * 
 * Als Evaluationsmodell wird gewählt:
 * - Die Verteilungen werden anhand der Parameter Tupel-Anzahl, maximale Tupelgröße und maximaler Tupel-Wert 
 * erzeugt sowie mit zwei Verteilungsfunktionen für die tatsächlichen Tupelgrößen und die einzelnen Tupelwerte 
 * (jeweils im Bereich von 1 bis zum gewählten Maximalwert).
 * - 
 * - Für jede Verteilung werden mehrere Datensätze erzeugt. 
 * - Für jeden Datensatz wird der Set Containment Join mehrfach berechnet und der Mittelwert der Laufzeiten verwendet.
 * 
 * @author akunkel
 *
 */
public class DoesRuntimeDependOnDistribution extends Executor {

	public DoesRuntimeDependOnDistribution(RawDataAlgorithm algorithm) {
		super(algorithm);
	}

	public static void main(String[] args) {

		Executor.MODE = EXECUTION_MODE.Time;

		
		LabelingSA alg = new LabelingSA();
		Executor exec = new DoesRuntimeDependOnDistribution(alg);

		for(int i=0;i < 5; i++) {
			Set<DataTuple>[] data = getGeneratedData(args);
			
			for(SortOrder order : new SortOrder[]{new FrequencyOrder(), new InverseFrequencyOrder()}) {
				alg.setSortOrder(order);
			
				Result r = new CountResultList(alg.getClass().getName());
	
				exec.preexecute(data[0], data[1], r);
	
				RuntimeCalculator rc = new RuntimeCalculator(order.getClass());
				
				rc.start("Dataset "+i);
				exec.execute(data[0], data[1], r);
				rc.stop("Dataset "+i);
				System.out.println(rc);
			
			}
		}
		

	}

	private static Set<DataTuple>[] getGeneratedData(String[] args) {
		
		@SuppressWarnings("unchecked")
		Set<DataTuple>[] trees = new Set[2];
		DataGenerator r = new DataGenerator();
		int tupleNumber = 2048;
		Distribution setSizeDistribution = Distribution.Zipf;
		int setSizeMax = 128;
		Distribution setElemDistribution = Distribution.Zipf;
		int setElemMax = 1024;
		trees[0] = r.getDataTuples(tupleNumber , setSizeDistribution, setSizeMax, setElemDistribution, setElemMax );
		trees[1] = r.getDataTuples(tupleNumber, setSizeDistribution, setSizeMax, setElemDistribution, setElemMax);
		return trees;
	}
	
}
