package scj.result;

import java.util.ArrayList;
import java.util.Iterator;

public class TupleResultList extends ArrayList<TuplePair> implements Result {

	private static final long serialVersionUID = 1L;
	private boolean verbose;
	private String algName;

    public TupleResultList() {
        this("",true);
    }

	public TupleResultList(String algName, boolean verbose) {
		this.algName = algName;
		this.verbose = verbose;
	}

	@Override
	public void add(int r, int s) {
		TuplePair tp = new TuplePair(r,s);
		this.add(tp);
	}

	@Override
	public void output() {
		if(!this.verbose) {
			return;
		}
		Iterator<TuplePair> it = this.iterator();
		while(it.hasNext()) {
			System.out.println(it.next());
		}
	}

    @Override
    public void add(Result result) {
        if(result instanceof TupleResultList) {
            final TupleResultList r = (TupleResultList) result;
            for(int i=0;i<r.size();i++) {
                this.add(r.get(i));
            }
        }

    }

    @Override
    public Result getSubresult() {
        return new TupleResultList();
    }

    @Override
	public String getName() {
		return this.algName;
	}

	@Override
	public void setName(String name) {
		this.algName = name;
	}

	@Override
	public Result withName(String name) {
		this.setName(name);
		return this;
	}

}
