package scj.result;


public class StringResultList extends ConfigurableResult {

	private StringBuilder sb;
	
	public StringResultList(String algName) {
		super(algName);
		sb = new StringBuilder();
	}
	
	@Override
	public void add(int r, int s) {
		sb.append(r + " x " + s+"\n");
		
	}

	@Override
	public void output() {		
		System.out.println(sb);
	}

    @Override
    public void add(Result result) {
        if(result instanceof StringResultList) {
            final StringResultList r = (StringResultList) result;
            sb.append(r.getString());
        }
    }

    @Override
    public Result getSubresult() {
        return new StringResultList(this.algName);
    }

    public String getString() {
        return String.valueOf(sb);
    }
}
