package scj.result;

import java.util.ArrayList;
import java.util.Iterator;


public class ResultList extends ArrayList<Result>{

	private static final long serialVersionUID = 1L;

	public String compareResults() {
		if(this.size() != 2) {
			return null;
		}

		if(	(this.get(0) instanceof TupleResultList)
				&& (this.get(1) instanceof TupleResultList)) {
			return compareTupleResultLists();
		}

		if(	(this.get(0) instanceof SynchronousTupleResultList)
				&& (this.get(1) instanceof TupleResultList)) {
			return compareSynchronousTupleResultListToTupleResultList();
		}

		return null;
	}

	private String compareSynchronousTupleResultListToTupleResultList() {
		StringBuilder txt = new StringBuilder();

		SynchronousTupleResultList trl1 = ((SynchronousTupleResultList) this.get(0));
		synchronized (trl1) {
			TupleResultList trl2 = (TupleResultList) ((TupleResultList) this.get(1)).clone();
			Iterator<TuplePair> it = trl1.iterator();
			while (it.hasNext()) {
				TuplePair entry = it.next();
				if (trl2.contains(entry)) {
					trl2.remove(entry);
				} else {
					txt.append("Only in set " + trl1.getName() + ": " + entry + "\n");
				}
			}
			it = trl2.iterator();
			while (it.hasNext()) {
				TuplePair entry = it.next();
				txt.append("Only in set " + trl2.getName() + ": " + entry + "\n");
				it.remove();
			}
		}
		return txt.toString();
	}

	public String compareTupleResultLists() {
		StringBuilder txt = new StringBuilder();

		TupleResultList trl1 = (TupleResultList) ((TupleResultList) this.get(0));
		TupleResultList trl2 = (TupleResultList) ((TupleResultList) this.get(1)).clone();
		Iterator<TuplePair> it = trl1.iterator();
		while(it.hasNext()) {
			TuplePair entry = it.next();
			if(trl2.contains(entry)) {
				trl2.remove(entry);
			} else {
				txt.append("Only in set "+trl1.getName()+": "+entry+"\n");
			}
		}
		it = trl2.iterator();
		while(it.hasNext()) {
			TuplePair entry = it.next();
			txt.append("Only in set "+trl2.getName()+": "+entry+"\n");
			it.remove();
		}
		return txt.toString();
	}

}
