package scj.result;


import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigInteger;

public class MyCountResultList extends ConfigurableResult {

	private static final Logger LOGGER = LoggerFactory.getLogger(MyCountResultList.class);

	protected long size;

	public MyCountResultList() {
		size = 0;
	}
	public MyCountResultList(String algName) {
		super(algName);
		size = 0;
	}
	
	@Override
	public void add(int r, int s) {
		size += 1;
	}

	@Override
	public void output() {		
		LOGGER.info("size0: {}", size);
	}

    @Override
    public void add(Result result) {
        if(result instanceof MyCountResultList) {
            size += (((MyCountResultList)result).size);
        }
    }

    @Override
    public Result getSubresult() {
        return new MyCountResultList();
    }

    public long getSize() {
		return size;
	}
}
