package scj.result;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;

public class FileTupleResultList extends ArrayList<TuplePair> implements Result {

	private static final long serialVersionUID = 1L;
	private boolean verbose;
	private String algName;

    public FileTupleResultList() {
        this("",true);
    }

	public FileTupleResultList(String algName, boolean verbose) {
		this.algName = algName;
		this.verbose = verbose;
	}

	@Override
	public void add(int r, int s) {
		TuplePair tp = new TuplePair(r,s);
		this.add(tp);
	}

	@Override
	public void output() {
		if(!this.verbose) {
			return;
		}
		this.sort(new Comparator<TuplePair>() {

			@Override
			public int compare(TuplePair arg0, TuplePair arg1) {
				// TODO Auto-generated method stub
				return arg0.compareTo(arg1);
			}
			
		});
		Iterator<TuplePair> it = this.iterator();
		try {
			int validIndex = 1;
			while(new File("results"+validIndex+".txt").exists()) {
				validIndex++;
			}
			PrintWriter writer = new PrintWriter("results"+validIndex+".txt", "UTF-8");
			while(it.hasNext()) {
				//System.out.println(it.next());
				writer.print(it.next()+"\r\n");
			}
			writer.close();
		} catch(Exception e) {
			System.err.println("couldn't write results to file");
		}
	}

    @Override
    public void add(Result result) {
        if(result instanceof FileTupleResultList) {
            final FileTupleResultList r = (FileTupleResultList) result;
            for(int i=0;i<r.size();i++) {
                this.add(r.get(i));
            }
        }

    }

    @Override
    public Result getSubresult() {
        return new FileTupleResultList();
    }

    @Override
	public String getName() {
		return this.algName;
	}

	@Override
	public void setName(String name) {
		this.algName = name;
	}

	@Override
	public Result withName(String name) {
		this.setName(name);
		return this;
	}

}
