package scj.result;


import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigInteger;

public class CountResultList2 extends ConfigurableResult {

	private static final Logger LOGGER = LoggerFactory.getLogger(CountResultList2.class);

	protected long size;

	public CountResultList2() {
		size = 0;
	}
	public CountResultList2(String algName) {
		super(algName);
		size = 0;
	}
	
	@Override
	public void add(int r, int s) {
		size += 1;
	}

	@Override
	public void output() {		
		LOGGER.info("size: {}", size);
	}

    @Override
    public void add(Result result) {
        if(result instanceof CountResultList2) {
            size += (((CountResultList2) result).size);
        }
    }

    @Override
    public Result getSubresult() {
        return new CountResultList2();
    }

    public long getSize() {
		return size;
	}
}
