package scj.result;


import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigInteger;

public class CountResultList extends ConfigurableResult {

	private static final Logger LOGGER = LoggerFactory.getLogger(CountResultList.class);

	protected BigInteger size;

	public CountResultList() {
		size = BigInteger.ZERO;
	}
	public CountResultList(String algName) {
		super(algName);
		size = BigInteger.ZERO;
	}
	
	@Override
	public void add(int r, int s) {
		size = size.add(BigInteger.ONE);
	}

	@Override
	public void output() {		
		LOGGER.info("size: {}", size.abs());
	}

    @Override
    public void add(Result result) {
        if(result instanceof CountResultList) {
            size.add(((CountResultList) result).size);
        }
    }

    @Override
    public Result getSubresult() {
        return new CountResultList();
    }

    public BigInteger getSize() {
		return size;
	}
}
