package scj.input.statistics;

import scj.input.DataTuple;
import scj.input.InputReader;
import scj.input.datasets.*;

import java.util.HashSet;
import java.util.Set;

/**
 * Created by Anja on 21.06.2015.
 */
public class DatasetStats {

    public static void main(String[] args) {
        new DatasetStats(new BMSInputReader());
        new DatasetStats(new FlickrInputReader());
        new DatasetStats(new KosarakInputReader());
        new DatasetStats(new NetflixInputReader());
        new DatasetStats(new LgylymInputReaderOrkut());
        new DatasetStats(new LgylymInputReaderWebbase());
    }
    public DatasetStats(InputReader input) {
        Set<DataTuple> tuples = input.getDataTuples()[0];
        final int tupleCount = tuples.size();

        int maxTupleSize = 0;
        int countElements = 0;
        Set<Integer> alphabet = new HashSet<>();
        for(DataTuple tuple : tuples) {
            final int length = tuple.getSet().length;
            if(maxTupleSize < length) {
                maxTupleSize = length;
            }
            countElements += length;

            for(int i=0;i<length;i++) {
                alphabet.add(tuple.getSet()[i]);
            }
        }
        int alphabetSize = alphabet.size();

        System.out.println(input.getClass().getName()+"\t"+tupleCount+"\t"+maxTupleSize+"\t"+countElements+"\t"+alphabetSize);
    }
}
