package scj.input;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InputReader {
	private static final Logger LOGGER = LoggerFactory.getLogger(InputReader.class);

	public InputReader() {
		super();
	}

	protected abstract String getFilename();

	public Set<DataTuple>[] getDataTuples(int line_limit) {
		
		@SuppressWarnings("unchecked")
		Set<DataTuple>[] trees = new Set[2];
		trees[0] = getDataTupleSet(line_limit, getFilename(), true);
		trees[1] = getDataTupleSet(line_limit, getFilename(), true);
		return trees;
	}
	public Set<DataTuple>[] getDataTuples() {

		@SuppressWarnings("unchecked")
		Set<DataTuple>[] trees = new Set[2];
		trees[0] = getDataTupleSet(-1, getFilename(), true);
		trees[1] = getDataTupleSet(-1, getFilename(), true);
		return trees;
	}

	protected Set<DataTuple> getDataTupleSet(int line_limit, String filename, boolean hasFirstLineWithAdditionalInformation) {
		Set<DataTuple> data = null;
		
		BufferedReader br;
		try {
			br = new BufferedReader(new FileReader(System.getProperty("scjInputFolder", "") + filename));
		
			String line;
			String[] contents;
			if (hasFirstLineWithAdditionalInformation) {
				if ((line = br.readLine()) != null) {
					contents = line.split(" ");
					int numRelationEntries = Integer.valueOf(contents[0]);
//				    int maximumSetValue = Integer.valueOf(contents[1]); // TODO how can i use this?
					data = new HashSet<>(numRelationEntries);
				}
			} else {
				data = new HashSet<>();
			}

			int line_number = 0;
			while ((line = br.readLine()) != null) {

                line_number ++;
				if(line_limit > 0 && line_number >= line_limit) {
					break;
				}

                final String content = getContentFromLine(line);
                if(content.trim().length()==0) {
                    continue;
                }
                String[] stringset = content.split(getSplitString());
				int[] set = new int[stringset.length];
				for(int i=0;i<stringset.length;i++) {
					try {
					  set[i] = Integer.parseInt(stringset[i]);
					} catch(NumberFormatException e) {
						LOGGER.error("Parser problem in stringset: "+ Arrays.toString(stringset) + "in line "+line);
					}
				}
				data.add(new DataTuple(line_number, set));
			}

			br.close();
		} catch (IOException e) {
			LOGGER.error("Exception!", e);
		}
		return data;
	}

    protected String getContentFromLine(String line) {
        return line.split("[\t ]", -1)[1];
    }

    protected String getSplitString() {
        return ",";
    }


}