package scj.input;

import java.util.Arrays;
import java.util.List;

import scj.algorithm.tree.Tuple;



public class DataTuple implements Comparable<DataTuple> {
	protected int id;
	protected int[] set;
	
	public DataTuple(int id, int[] set) {
		this.id = id;
		this.set = set;
	}

	/*
	 * For testing only.
	 */
	public DataTuple(Tuple tuple, List<String> stringlist) {
		this.id = tuple.getId();
		
		this.set = new int[stringlist.size()];
		for(int i=0;i<stringlist.size();i++) {
			set[i] = Integer.parseInt(stringlist.get(i));
		}
	}

	@Override
	public String toString() {
		return "DataTuple [id=" + id + ", set=" + Arrays.toString(set) + "]";
	}

	public int getId() {
		return id;
	}
	
	public void setId(int id) {
		this.id = id;
	}
	public int[] getSet() {
		return set;
	}
	public void setSet(int[] set) {
		this.set = set;
	}

	@Override
	public int compareTo(DataTuple o) {
		return Integer.compare(getId(),o.getId());
	}
}
