package scj.evaluation.evals.stats;

import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import scj.algorithm.ConfigurableRawDataAlgorithm;
import scj.algorithm.order.FrequencyOrder;
import scj.algorithm.order.InverseFrequencyOrder;
import scj.algorithm.order.SortOrder;
import scj.algorithm.tree.leftside.FlatLeftTree;
import scj.algorithm.tree.leftside.FlatLeftTreeDirectBuildMinPathLength;
import scj.algorithm.tree.rightside.PIETreeMaxPathLength;
import scj.algorithm.twotrees.labeling.flat.FlatBoth;
import scj.algorithm.twotrees.labeling.minmax.FlatTreeCreatorLeftSideDirectMinPathLength;
import scj.algorithm.twotrees.labeling.minmax.FlatTreeCreatorRightSideDirectMaxPathLength;
import scj.algorithm.twotrees.labeling.minmax.analysis.*;
import scj.evaluation.Executor;
import scj.input.DataTuple;
import scj.result.CountResultList;
import scj.result.Result;
import scj.runtime.Executable;
import scj.runtime.RuntimeCalculator;

import java.util.Map;
import java.util.Set;

public class FBMinMaxHistograms extends FlatBoth {


    public static void main(String[] args) {

        for(Executor.EXECUTION_MODE mode : new Executor.EXECUTION_MODE[]{Executor.EXECUTION_MODE.Time}) {
            String dataSet = args[0];
            Executor.run(CountResultList.class, dataSet, mode, getBenchmarkAlgorithms(args[1]));
        }

    }


    public static ConfigurableRawDataAlgorithm[] getBenchmarkAlgorithms(String arg) {
        ConfigurableRawDataAlgorithm[] algorithms = new ConfigurableRawDataAlgorithm[1];
        SortOrder order;

        if(arg.equals("freq")) {
            order = new FrequencyOrder();
        } else {
            order = new InverseFrequencyOrder();
        }
        algorithms[0] = new FBMinMaxHistograms().withSortOrder(order);

        return algorithms;
    }

    @Override
	public void execute(final Set<DataTuple> n_a, final Set<DataTuple> n_b, Result result) {
		RuntimeCalculator rc = new RuntimeCalculator(this.getClass());

        final FlatLeftTreeDirectBuildMinPathLength t1 = rc.measure(new Executable<FlatLeftTreeDirectBuildMinPathLength>() {
            public FlatLeftTreeDirectBuildMinPathLength execute() {
                return (FlatLeftTreeDirectBuildMinPathLength) new FlatTreeCreatorLeftSideDirectMinPathLength().getInnerFlatTree(n_a, sortOrder);
            }
        }, "build prefix tree 1 -- build up phase");
        rc.measure(new Executable<FlatLeftTree>() {
            public FlatLeftTree execute() {
                t1.complete();
                return t1;
            }
        }, "build prefix tree 1 -- completion");
        LOGGER.debug("Prefix tree of data set 1: {}", t1);

        PIETreeMaxPathLength t2=
                rc.measure(new Executable<PIETreeMaxPathLength>() {
                    public PIETreeMaxPathLength execute() {
                        return (PIETreeMaxPathLength) new FlatTreeCreatorRightSideDirectMaxPathLength().getOuterFlatTree(n_b, sortOrder);
                    }
                }, "build prefix tree 2");
        LOGGER.debug("Prefix tree of data set 2: {}", t2);
		LOGGER.info("{}", rc);

        // Frequency Maps von MinMax
        //System.out.println(this.getFrequencyMap(t1));
        //System.out.println(this.getFrequencyMapMax(t2));

    //    new MinMaxSearchAnalysisPruningQuota(t1, t2, result).search();
    //    new MinMaxSearchAnalysisCallCount(t1, t2, result).search();
    //    new MinMaxSearchAnalysisTimeAtOutput(t1, t2, result).search();
        new MinMaxSearchAnalysisTimeAtFirstLevels(t1, t2, result).search();

     //   new FlatSearchAnalysisSizeCorrelations(t1, t2, result).search();
        //printSizeMapR(t1);
        //printSizeMapS(t2);
	}

    private Map<Integer, Integer> getFrequencyMapMax(PIETreeMaxPathLength t2) {
        Map<Integer, Integer> alphabet = new Int2IntOpenHashMap(t2.getSize());

        for(int i=0;i<t2.getSize();i++) {
            int entry = t2.getMaxPathLengthOf(i);
            if(alphabet.containsKey(entry)) {
                alphabet.put(entry, alphabet.get(entry)+1);
            } else {
                alphabet.put(entry, 1);
            }
        }
        return alphabet;
    }

    private Map<Integer, Integer> getFrequencyMap(FlatLeftTreeDirectBuildMinPathLength t1) {
        Map<Integer, Integer> alphabet = new Int2IntOpenHashMap(t1.getSize());

        for(int i=0;i<t1.getSize();i++) {
            int entry = t1.getMinPathLengthOf(i);
            if(alphabet.containsKey(entry)) {
                alphabet.put(entry, alphabet.get(entry)+1);
            } else {
                alphabet.put(entry, 1);
            }
        }
        return alphabet;
    }

    private int findTupleSizeOf(int nodeId, FlatLeftTree R) {
        //  If leaf -> 0 or has tupleId.
        IntList c = R.getChildrenOf(nodeId);
        IntListIterator it = c.iterator();
        int size = R.getIdsByPosition(nodeId).size();
        while(it.hasNext()) {
            int child = it.nextInt();
            size += findTupleSizeOf(child, R);
        }
        LOGGER.info("tuples\t{}\t{}", nodeId, size);
        return size;
    }
    private int findSizeOf(int nodeId, FlatLeftTree R) {
        //  If leaf -> 0 or has tupleId.
        IntList c = R.getChildrenOf(nodeId);
        IntListIterator it = c.iterator();
        int size = 1;
        while(it.hasNext()) {
            int child = it.nextInt();
            size += findSizeOf(child, R);
        }
        LOGGER.info("nodes\t{}\t{}",nodeId,size);
        return size;
    }

    private void printSizeMapR(FlatLeftTreeDirectBuildMinPathLength t1) {
        findSizeOf(0, t1);
        findTupleSizeOf(0, t1);
    }

    private void printSizeMapS(PIETreeMaxPathLength t2) {

        for(int i=0;i<t2.getSize();i++) {
            LOGGER.info("nodesS\t{}\t{}", i, t2.getRangeEnd(i)-i+1);
            LOGGER.info("tuplesS\t{}\t{}", i, t2.getIdsByPosition(i,t2.getRangeEnd(i)));
        }
    }
}
