package scj.evaluation.evals;

import scj.algorithm.ConfigurableRawDataAlgorithm;
import scj.algorithm.RawDataAlgorithm;
import scj.algorithm.order.InverseFrequencyOrder;
import scj.algorithm.order.SortOrder;
import scj.algorithm.parallel.adaptiveranging.AdaptiveRanging;
import scj.algorithm.parallel.listtask.L1ListTask;
import scj.algorithm.parallel.nodetask.switching.SwitchByLevel;
import scj.algorithm.parallel.rangetask.L1RangeTask;
import scj.algorithm.twotrees.labeling.flat.FlatBoth;
import scj.evaluation.Executor;
import scj.result.CountResultList;

public class MultithreadedEvaluation extends Executor {

	public MultithreadedEvaluation(RawDataAlgorithm algorithm) {
		super(algorithm);
	}
	
	public static void main(String[] args) {

		for(EXECUTION_MODE mode : new EXECUTION_MODE[]{EXECUTION_MODE.Time}) {
			String dataSet = args[0];
			run(CountResultList.class, dataSet, mode, getBenchmarkAlgorithms());
		}
		
	}

	
	public static ConfigurableRawDataAlgorithm[] getBenchmarkAlgorithms() {
		ConfigurableRawDataAlgorithm[] algorithms = new ConfigurableRawDataAlgorithm[1];
		SortOrder order;
		
		order = new InverseFrequencyOrder();
		//algorithms[1] = new OneTask().withSortOrder(order);
        //algorithms[0] = new FlatBoth().withSortOrder(order);
        algorithms[0] = new AdaptiveRanging().withSortOrder(order);
		
		return algorithms;
	}

}
