package scj.evaluation.evals;

import scj.algorithm.ConfigurableRawDataAlgorithm;
import scj.algorithm.RawDataAlgorithm;
import scj.algorithm.order.FrequencyOrder;
import scj.algorithm.order.InverseFrequencyOrder;
import scj.algorithm.order.SortOrder;
import scj.algorithm.twotrees.labeling.flat.FlatBoth;
import scj.algorithm.twotrees.labeling.listrecursion.FlatListBasedRecursion;
import scj.algorithm.twotrees.labeling.minmax.FlatBothMinMax;
import scj.evaluation.Executor;
import scj.result.CountResultList;

public class MinMaxEvaluation extends Executor {

	public MinMaxEvaluation(RawDataAlgorithm algorithm) {
		super(algorithm);
	}
	
	public static void main(String[] args) {

		for(EXECUTION_MODE mode : new EXECUTION_MODE[]{EXECUTION_MODE.Time}) {
			String dataSet = args[0];
			run(CountResultList.class, dataSet, mode, getBenchmarkAlgorithms());
		}
		
	}

	
	public static ConfigurableRawDataAlgorithm[] getBenchmarkAlgorithms() {
		ConfigurableRawDataAlgorithm[] algorithms = new ConfigurableRawDataAlgorithm[4];
		SortOrder order;
		
		order = new FrequencyOrder();		
		algorithms[1] = new FlatBoth().withSortOrder(order);
		algorithms[0] = new FlatBothMinMax().withSortOrder(order);
		
		order = new InverseFrequencyOrder();
		algorithms[2] = new FlatBoth().withSortOrder(order);
		algorithms[3] = new FlatBothMinMax().withSortOrder(order);
		
		return algorithms;
	}

}
