package scj.evaluation.evals;

import scj.algorithm.ConfigurableRawDataAlgorithm;
import scj.algorithm.RawDataAlgorithm;
import scj.algorithm.order.FrequencyOrder;
import scj.algorithm.order.InverseFrequencyOrder;
import scj.algorithm.order.SortOrder;
import scj.algorithm.twotrees.labeling.flat.FlatBoth;
import scj.algorithm.twotrees.labeling.flat.FlatLeft;
import scj.algorithm.twotrees.labeling.flat.FlatNone;
import scj.algorithm.twotrees.labeling.sa.LabelingSA;
import scj.evaluation.Executor;
import scj.result.CountResultList;

public class FlatBothEvaluation extends Executor {

	public FlatBothEvaluation(RawDataAlgorithm algorithm) {
		super(algorithm);
	}
	
	public static void main(String[] args) {

		for(EXECUTION_MODE mode : new EXECUTION_MODE[]{EXECUTION_MODE.TimeBuildUp}) {
			String dataSet = args[0];
			run(CountResultList.class, dataSet, mode, getBenchmarkAlgorithms());
		}
		
	}

	
	public static ConfigurableRawDataAlgorithm[] getBenchmarkAlgorithms() {
		ConfigurableRawDataAlgorithm[] algorithms = new ConfigurableRawDataAlgorithm[1];
		SortOrder order;
		
		order = new FrequencyOrder();
		algorithms[0] = new FlatBoth().withSortOrder(order);
		
		//order = new InverseFrequencyOrder();
		//algorithms[1] = new FlatBoth().withSortOrder(order);
		
		return algorithms;
	}

}
