package scj.evaluation.evals;

import scj.algorithm.ConfigurableRawDataAlgorithm;
import scj.algorithm.RawDataAlgorithm;
import scj.algorithm.order.FrequencyOrder;
import scj.algorithm.order.InverseFrequencyOrder;
import scj.algorithm.order.SortOrder;
import scj.algorithm.twotrees.labeling.flat.FlatBoth;
import scj.algorithm.twotrees.labeling.flat.FlatLeft;
import scj.algorithm.twotrees.labeling.flat.FlatNone;
import scj.algorithm.twotrees.labeling.flat.FlatRight;
import scj.evaluation.Executor;
import scj.result.CountResultList;

public class BuildUpModeEvaluation extends Executor {

	public BuildUpModeEvaluation(RawDataAlgorithm algorithm) {
		super(algorithm);
	}
	
	public static void main(String[] args) {

		for(EXECUTION_MODE mode : new EXECUTION_MODE[]{EXECUTION_MODE.Time, EXECUTION_MODE.Space}) {
			String dataSet = args[0];//,"flickr","kosarak","netflix"
			run(CountResultList.class, dataSet, mode, getBenchmarkAlgorithms());
		}
		
	}

	
	public static ConfigurableRawDataAlgorithm[] getBenchmarkAlgorithms() {
		ConfigurableRawDataAlgorithm[] algorithms = new ConfigurableRawDataAlgorithm[8];
		SortOrder order;
		
		order = new FrequencyOrder();		
		algorithms[0] = new FlatLeft().withSortOrder(order);
		algorithms[1] = new FlatNone().withSortOrder(order);
		algorithms[2] = new FlatRight().withSortOrder(order);
		algorithms[3] = new FlatBoth().withSortOrder(order);
		
		order = new InverseFrequencyOrder();
		algorithms[4] = new FlatLeft().withSortOrder(order);
		algorithms[5] = new FlatNone().withSortOrder(order);
		algorithms[6] = new FlatRight().withSortOrder(order);
		algorithms[7] = new FlatBoth().withSortOrder(order);
		
		return algorithms;
	}

}
