package scj.evaluation;

import java.util.Set;

import scj.input.DataTuple;
import scj.input.InputReader;
import scj.input.datasets.*;

public class SystemSetup {

	protected static Set<DataTuple>[] readFile(String algorithmName, int line_limit) {

		InputReader reader = null;
		if (algorithmName.equals("bms-pos")) {
			reader = new BMSInputReader();
		} else if (algorithmName.equals("example")) {
			reader = new ExampleInputReader();
		} else if (algorithmName.equals("flickr")) {
			reader = new FlickrInputReader();
		} else if (algorithmName.equals("netflix")) {
			reader = new NetflixInputReader();
        } else if (algorithmName.equals("kosarak")) {
            reader = new KosarakInputReader();
		} else if (algorithmName.equals("netflix-1090")) {
			reader = new NetflixPartsPanosInputReader("10","90");
		} else if (algorithmName.equals("netflix-3070")) {
			reader = new NetflixPartsPanosInputReader("30","70");
		} else if (algorithmName.equals("netflix-5051")) {
			reader = new NetflixPartsPanosInputReader("50","51");
		} else if (algorithmName.equals("netflix-7030")) {
			reader = new NetflixPartsPanosInputReader("70","30");
		} else if (algorithmName.equals("netflix-9010")) {
			reader = new NetflixPartsPanosInputReader("90","10");
        } else if (algorithmName.equals("orkut")) {
            reader = new OrkutINPReader();
        } else if (algorithmName.equals("webbase")) {
            reader = new WebbaseINPReader();
		} else if (algorithmName.equals("flickr2")) {
			reader = new Flickr2InputReader();
		} else if (algorithmName.equals("twitter")) {
			reader = new TwitterInputReader();
		}

		Set<DataTuple>[] input = null;
		if (reader != null) {
			input = reader.getDataTuples(line_limit);
		}
		return input;
	}

}