package scj.evaluation;

import scj.algorithm.ConfigurableRawDataAlgorithm;
import scj.algorithm.RawDataAlgorithm;
import scj.algorithm.order.SortOrder;
import scj.algorithm.parallel.DAParallelAlgorithm;
import scj.algorithm.pretti.Pretti;
import scj.algorithm.twotrees.labeling.DAAlgorithm;
import scj.algorithm.twotrees.labeling.sa.LabelingSA;
import scj.input.DataTuple;
import scj.result.CountResultList;
import scj.result.Result;
import scj.runtime.RuntimeCalculator;

import java.util.Set;

public class ParallelizedBenchmarkExecutor extends BenchmarkExecutor {

	public ParallelizedBenchmarkExecutor(RawDataAlgorithm algorithm) {
		super(algorithm);
	}

	public static void main(String[] args) {

		Executor.MODE = getExecutionMode(args);

		ConfigurableRawDataAlgorithm alg = getAlgorithm(args);

        if (!(alg instanceof DAParallelAlgorithm)) {
            System.out.println("Invalid algorithm.");
            System.exit(1);
        }
        DAParallelAlgorithm daAlgorithm = (DAParallelAlgorithm) alg;

        SortOrder order = getSortOrder(args);
        daAlgorithm.setSortOrder(order);

        int parallelism = getParallelism(args);
        daAlgorithm.setThreads(parallelism);



		Executor exec = new ParallelizedBenchmarkExecutor(alg);

		Result r = new CountResultList(alg.getClass().getName());

		Set<DataTuple>[] data = getExample(args);
		exec.preexecute(data[0], data[1], r);

		RuntimeCalculator rc = new RuntimeCalculator(alg.getClass());
		rc.start("execute");
		exec.execute(data[0], data[1], r);
		rc.stop("execute");
		System.out.println(rc);

	}

	private static ConfigurableRawDataAlgorithm getAlgorithm(String[] args) {

		final int argsOffset = 2;

		if (args.length == 0 + argsOffset) {
			System.out.println("You have to specify an algorithm.");
			System.exit(1);
		}

		String algorithmName = args[0 + argsOffset];

		ConfigurableRawDataAlgorithm algorithm = getParallelAlgorithmByName(algorithmName);

		return algorithm;
	}

    protected static Set<DataTuple>[] getExample(String[] args) {
        final int argsOffset = 3;

        if (args.length == 0 + argsOffset) {
            System.out.println("You have to specify an input file.");
            System.exit(1);
        }

        String dataSetName = args[0 + argsOffset];
        int line_limit = -1;
        return getInputData(dataSetName, line_limit);
    }

    protected static int getParallelism(String[] args) {
        final int argsOffset = 4;

        if (args.length == 0 + argsOffset) {
            System.out.println("You have to specify a degree of parallelism.");
            System.exit(1);
        }

        String par = args[0 + argsOffset];
        return Integer.parseInt(par);
    }


}
