package scj.evaluation;

import scj.algorithm.ConfigurableRawDataAlgorithm;
import scj.algorithm.RawDataAlgorithm;
import scj.algorithm.limitcomplete.LIMIT;
import scj.algorithm.limitcomplete.LIMITOPJ;
import scj.algorithm.limitcomplete.LIMITOPJINDEXING;
import scj.algorithm.order.FrequencyOrder;
import scj.algorithm.order.InverseFrequencyOrder;
import scj.algorithm.pretti.Pretti;
import scj.algorithm.twotrees.labeling.flat.FlatBoth;
import scj.algorithm.twotrees.labeling.minmax.FlatBothMinMax;
import scj.result.CountResultList;
import scj.result.CountResultList2;
import scj.result.MyCountResultList;
import scj.result.TupleResultList;

public class MeasureEvaluation extends Executor {

	public MeasureEvaluation(RawDataAlgorithm algorithm) {
		super(algorithm);
	}
	
	public static void main(String[] args) {
		
		// read inputs
		if(args.length < 4) {
			System.out.println("too few arguments:");
			System.out.println(" [dataSet] [alg] [ASC|DESC] [limit] {repetitions}");
			System.exit(0);
		}
		String dataSet = args[0];
		String alg = args[2];
		String sOrder = args[1].toUpperCase();
		int limit = Integer.parseInt(args[3]);
		
		if(!(sOrder.equals("ASC") || sOrder.equals("DESC"))) {
			System.out.println("sort order needs to be ASC or DESC");
			System.exit(0);
		}

//		Executor.EXECUTION_MODE em = Executor.EXECUTION_MODE.Time;
//		if(args.length > 4) {
//			String mode = args[4].toUpperCase();
//			if(mode.equals("SPACE")) 
//				em = Executor.EXECUTION_MODE.Space;
//		}
		
		int reps = 1;
		if(args.length > 4) {
			reps = Integer.parseInt(args[4]);
		}
		EXECUTION_MODE em = EXECUTION_MODE.Time;
		if(args.length > 5) {
			String mode = args[5];
			if(mode.toLowerCase().equals("space")) 
				em = EXECUTION_MODE.Space;
		}
		
		// run
		for(int i=0; i<reps; i++) {
			run(CountResultList2.class, dataSet, em, getBenchmarkAlgorithms(alg.toLowerCase(), limit, sOrder));
		}
	}

	
	public static ConfigurableRawDataAlgorithm[] getBenchmarkAlgorithms(String alg, int limit, String sOrder) {
		ConfigurableRawDataAlgorithm[] algorithms = new ConfigurableRawDataAlgorithm[1];

		if(alg.equals("pretti"))
			algorithms[0] = new Pretti();//.withSortOrder(order);
		else if(alg.equals("limit"))
			algorithms[0] = new LIMIT(limit, sOrder);
//		else if(alg.equals("limitplus"))
//			algorithms[0] = new LIMITPLUS(limit, sOrder);
		else if(alg.equals("limitopj"))
			algorithms[0] = new LIMITOPJ(limit, sOrder);
//		else if(alg.equals("limitplusopj"))
//			algorithms[0] = new LIMITPLUSOPJ(limit, sOrder);
		else if(alg.equals("limitopj_index"))
			algorithms[0] = new LIMITOPJINDEXING(limit, sOrder);
		else if(alg.equals("piejoin")) {
			if(sOrder.toUpperCase().equals("ASC"))
				algorithms[0] = new FlatBoth().withSortOrder(new InverseFrequencyOrder());
			if(sOrder.toUpperCase().equals("DESC"))
				algorithms[0] = new FlatBoth().withSortOrder(new FrequencyOrder());
		}

		return algorithms;
	}

}
