package scj.evaluation;

import java.util.Set;

import scj.algorithm.ConfigurableRawDataAlgorithm;
import scj.algorithm.RawDataAlgorithm;
import scj.algorithm.pretti.Pretti;
import scj.algorithm.twotrees.labeling.DAAlgorithm;
import scj.algorithm.twotrees.labeling.sa.LabelingSA;
import scj.input.DataTuple;
import scj.algorithm.order.SortOrder;
import scj.result.CountResultList;
import scj.result.Result;
import scj.runtime.RuntimeCalculator;

public class BenchmarkExecutor extends Executor {

	public BenchmarkExecutor(RawDataAlgorithm algorithm) {
		super(algorithm);
	}

	public static void main(String[] args) {

		Executor.MODE = getExecutionMode(args);

		SortOrder order = getSortOrder(args);

		ConfigurableRawDataAlgorithm alg = getAlgorithm(args);

        if (alg instanceof DAAlgorithm) {
            ((DAAlgorithm) alg).setSortOrder(order);
        } else if (alg instanceof LabelingSA) {
            ((LabelingSA) alg).setSortOrder(order);
        } else if (alg instanceof Pretti) {
            ((Pretti) alg).setSortOrder(order);
        }

		Executor exec = new BenchmarkExecutor(alg);

		Result r = new CountResultList(alg.getClass().getName());

		Set<DataTuple>[] data = getExample(args);
		exec.preexecute(data[0], data[1], r);

		RuntimeCalculator rc = new RuntimeCalculator(alg.getClass());
		rc.start("execute");
		exec.execute(data[0], data[1], r);
		rc.stop("execute");
		System.out.println(rc);

		// r.output();

	}

	protected static EXECUTION_MODE getExecutionMode(String[] args) {
		final int argsOffset = 0;

		if (args.length == 0 + argsOffset) {
			System.out.println("You have to specify an execution mode.");
			System.exit(1);
		}

		String executionMode = args[0 + argsOffset];

        if (executionMode.equals("time")) {
            return EXECUTION_MODE.Time;
        }
        if (executionMode.equals("timebuildup")) {
            return EXECUTION_MODE.TimeBuildUp;
        }
		return EXECUTION_MODE.Space;
	}

	protected static SortOrder getSortOrder(String[] args) {
		final int argsOffset = 1;

		return getSortOrderByOffset(args, argsOffset);
	}

	private static ConfigurableRawDataAlgorithm getAlgorithm(String[] args) {

		final int argsOffset = 2;

		if (args.length == 0 + argsOffset) {
			System.out.println("You have to specify an algorithm.");
			System.exit(1);
		}

		String algorithmName = args[0 + argsOffset];

		ConfigurableRawDataAlgorithm algorithm = getAlgorithmByName(algorithmName);

		return algorithm;

	}

	protected static Set<DataTuple>[] getExample(String[] args) {
		final int argsOffset = 3;

		return getDataTuplesByOffset(args, argsOffset);
	}
}
