package scj.algorithm.twotrees.labeling.sa;

import java.util.Set;

import scj.algorithm.TreeType;
import scj.input.DataTuple;
import scj.algorithm.order.SortOrder;
import scj.algorithm.tree.Node;
import scj.algorithm.tree.TTTreeNode;
import scj.algorithm.tree.TreeNode;
import scj.algorithm.tree.rightside.PIETree;
import scj.algorithm.tree.TreeNodeWithIntervalAnnotation;

public class EncodedTreeCreator {
    public Node createInnerTree(Set<DataTuple> data, SortOrder sortOrder) {
        return getPrefixTree(data, sortOrder, TreeType.InnerTree);
    }

    public Node createOuterTreeFromPrefixTree(Node prefixTree) {
        return new PIETree(prefixTree);
    }

    protected Node getPrefixTree(Set<DataTuple> data, SortOrder sortOrder,
			TreeType type) {
		TreeNode rootNode = getTreeNode(TreeNode.DEFAULT_VALUE, type);
		for (DataTuple date : data) {
			// Go to the matching position
			Node traverser = rootNode;
			Node tmp;
			for (int contentElement : date.getSet()) {
				tmp = traverser.getChild(contentElement);
				if (tmp == null) {
					tmp = getTreeNode(contentElement, type);
					traverser.addChild(tmp);
				}
				traverser = tmp;
			}
			traverser.addContent(date.getId());

		}

		if (rootNode instanceof TTTreeNode) {
			((TTTreeNode) rootNode).postCreate();
		}

		return rootNode;
	}

	protected TreeNode getTreeNode(int contentElement, TreeType type) {
		if (type == TreeType.OuterTree) {
			return new TreeNodeWithIntervalAnnotation(contentElement);
		}
		return new TreeNode(contentElement);
	}

}
