package scj.algorithm.twotrees.labeling.sa;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import scj.algorithm.twotrees.Search;
import scj.result.Result;
import scj.algorithm.tree.Node;
import scj.algorithm.tree.TreeNode;
import scj.algorithm.tree.rightside.PIETree;

public class EncodedSearch implements Search {

	private static final Logger LOGGER = LoggerFactory.getLogger(EncodedSearch.class);
	
	protected Node a;
	protected Result result;

	private PIETree S;

	public EncodedSearch(Node n_a, Node t2, Result result) {
		this.a = n_a;
		this.S = (PIETree) t2;
		this.result = result;
	}

	@Override
	public Result search() {
//		long tmp = System.currentTimeMillis();
		this.search(a, 0);
//		LOGGER.info("EncodedRangeTreeFlat execution time: findRanges {} ms, getIdsByPosition {} ms", S.findRangesTime, S.getIdsByPositionTime);
//		long tmp2 = System.currentTimeMillis()-tmp;
//		LOGGER.info("search(): {} ms", tmp2);
		return result;
	}
	
	public String toString() {
		return a + "\n" + S;
	}
	
	/*
	 * Search.
	 */	
	protected void search(Node n_r, int scope_start) {
//		LOGGER.debug("Visiting node {} and interval [{}.{}]",n_r,scope_start,  S.getRangeEnd(scope_start));
		
		
		IntList content_r = ((TreeNode) n_r).getTupleIds();
		if (!content_r.isEmpty()) {
			lookForOutput(content_r, scope_start);
		}

		// Traversal
		for (Node c_r : n_r.getChildren()) {
			IntList result = S.findRanges(c_r.getName(), scope_start);
			IntListIterator resultItr = result.iterator();
			while(resultItr.hasNext()) {
				search(c_r, resultItr.nextInt());
			}
		}
	}

	private void lookForOutput(IntList content_r, int scope_start) {
		
		// Build set of results on right side
		IntCollection result_s = S.getIdsByPosition(scope_start, S.getRangeEnd(scope_start) + 1);
		
		IntListIterator it_r = content_r.iterator();
		while(it_r.hasNext()) {
			int nextInt = it_r.nextInt();
			IntIterator it_s = result_s.iterator();
			while(it_s.hasNext()) {
				result.add(nextInt, it_s.nextInt());				
			}
		}		
	}
}
